/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.pipeline;

import iep.io.reactivex.netty.channel.NewRxConnectionEvent;
import iep.io.reactivex.netty.channel.ObservableConnection;
import iep.io.reactivex.netty.client.ConnectionReuseEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import rx.Observer;

public class ObservableAdapter
extends ChannelInboundHandlerAdapter {
    private Observer bridgedObserver;
    private boolean autoReleaseBuffers;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        Boolean autoRelease = (Boolean)ctx.channel().attr(ObservableConnection.AUTO_RELEASE_BUFFERS).get();
        this.autoReleaseBuffers = null == autoRelease || autoRelease != false;
        super.handlerAdded(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (null != this.bridgedObserver) {
            try {
                this.bridgedObserver.onNext(msg);
            }
            catch (ClassCastException cce) {
                this.bridgedObserver.onError((Throwable)new RuntimeException("Mismatched message type.", cce));
            }
            finally {
                if (this.autoReleaseBuffers) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (null != this.bridgedObserver) {
            this.bridgedObserver.onError(cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (null != this.bridgedObserver) {
            this.bridgedObserver.onCompleted();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof NewRxConnectionEvent) {
            NewRxConnectionEvent rxConnectionEvent = (NewRxConnectionEvent)event;
            this.bridgedObserver = rxConnectionEvent.getConnectedObserver();
        } else if (event instanceof ConnectionReuseEvent) {
            ConnectionReuseEvent reuseEvent = (ConnectionReuseEvent)event;
            this.bridgedObserver = reuseEvent.getConnectedObserver();
        }
        super.userEventTriggered(ctx, event);
    }
}

