/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.client;

import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import iep.io.reactivex.netty.pipeline.PipelineConfigurator;
import iep.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.TimeUnit;

class ClientRequiredConfigurator<I, O>
implements PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> {
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    private final long responseSubscriptionTimeout;
    private final TimeUnit responseSubscriptionTimeoutUnit;

    public ClientRequiredConfigurator(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this(eventsSubject, 0L, TimeUnit.MILLISECONDS);
    }

    public ClientRequiredConfigurator(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject, long responseSubscriptionTimeout, TimeUnit responseSubscriptionTimeoutUnit) {
        this.eventsSubject = eventsSubject;
        this.responseSubscriptionTimeout = responseSubscriptionTimeout;
        this.responseSubscriptionTimeoutUnit = responseSubscriptionTimeoutUnit;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        ClientRequestResponseConverter converter = (ClientRequestResponseConverter)pipeline.get(ClientRequestResponseConverter.class);
        if (null == converter) {
            pipeline.addLast("request-response-converter", (ChannelHandler)new ClientRequestResponseConverter(this.eventsSubject, this.responseSubscriptionTimeout, this.responseSubscriptionTimeoutUnit));
        }
    }
}

