/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.server.file;

import iep.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import iep.io.reactivex.netty.protocol.http.server.RequestHandler;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;

public abstract class AbstractFileRequestHandler
implements RequestHandler<ByteBuf, ByteBuf> {
    public static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    public static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;

    public static void setDateHeader(HttpServerResponse<ByteBuf> response, SimpleDateFormat dateFormatter) {
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.getHeaders().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    public static void setDateAndCacheHeaders(HttpServerResponse<ByteBuf> response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.getHeaders().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.getHeaders().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.getHeaders().set("Cache-Control", (Object)"private, max-age=60");
        response.getHeaders().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    public static void setContentTypeHeader(HttpServerResponse<ByteBuf> response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.getHeaders().set("Content-Type", (Object)mimeTypesMap.getContentType(file.getPath()));
    }

    public static String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Unable to decode URI '%s'", uri), e);
        }
        if (!uri.startsWith("/")) {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.startsWith(".") || uri.endsWith(".") || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return uri;
    }
}

