/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.sse;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEvent
implements ByteBufHolder {
    private static final Logger logger = LoggerFactory.getLogger(ServerSentEvent.class);
    private static Charset sseEncodingCharset;
    private final Type type;
    private final ByteBuf data;
    private final ByteBuf eventId;
    private final ByteBuf eventType;

    public ServerSentEvent(Type type, ByteBuf data) {
        this(type, null, null, data);
    }

    public ServerSentEvent(ByteBuf data) {
        this(Type.Data, data);
    }

    public ServerSentEvent(ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        this(Type.Data, eventId, eventType, data);
    }

    protected ServerSentEvent(Type type, ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        this.data = data;
        this.type = type;
        this.eventId = eventId;
        this.eventType = eventType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasEventId() {
        return null != this.eventId;
    }

    public boolean hasEventType() {
        return null != this.eventType;
    }

    public ByteBuf getEventId() {
        return this.eventId;
    }

    public String getEventIdAsString() {
        return this.eventId.toString(this.getSseCharset());
    }

    public ByteBuf getEventType() {
        return this.eventType;
    }

    public String getEventTypeAsString() {
        return this.eventType.toString(this.getSseCharset());
    }

    public String contentAsString() {
        return this.data.toString(this.getSseCharset());
    }

    public ByteBuf content() {
        return this.data;
    }

    public ByteBufHolder copy() {
        return new ServerSentEvent(this.type, null != this.eventId ? this.eventId.copy() : null, null != this.eventType ? this.eventType.copy() : null, this.data.copy());
    }

    public ByteBufHolder duplicate() {
        return new ServerSentEvent(this.type, null != this.eventId ? this.eventId.duplicate() : null, null != this.eventType ? this.eventType.duplicate() : null, this.data.duplicate());
    }

    public ByteBufHolder retainedDuplicate() {
        return this.duplicate().retain();
    }

    public ByteBufHolder replace(ByteBuf content) {
        return new ServerSentEvent(content);
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public ByteBufHolder touch() {
        if (this.hasEventId()) {
            this.eventId.touch();
        }
        if (this.hasEventType()) {
            this.eventType.touch();
        }
        this.data.touch();
        return this;
    }

    public ByteBufHolder touch(Object hint) {
        if (this.hasEventId()) {
            this.eventId.touch(hint);
        }
        if (this.hasEventType()) {
            this.eventType.touch(hint);
        }
        this.data.touch(hint);
        return this;
    }

    public ByteBufHolder retain() {
        if (this.hasEventId()) {
            this.eventId.retain();
        }
        if (this.hasEventType()) {
            this.eventType.retain();
        }
        this.data.retain();
        return this;
    }

    public ByteBufHolder retain(int increment) {
        if (this.hasEventId()) {
            this.eventId.retain(increment);
        }
        if (this.hasEventType()) {
            this.eventType.retain(increment);
        }
        this.data.retain(increment);
        return this;
    }

    public boolean release() {
        if (this.hasEventId()) {
            this.eventId.release();
        }
        if (this.hasEventType()) {
            this.eventType.release();
        }
        return this.data.release();
    }

    public boolean release(int decrement) {
        if (this.hasEventId()) {
            this.eventId.release(decrement);
        }
        if (this.hasEventType()) {
            this.eventType.release(decrement);
        }
        return this.data.release(decrement);
    }

    public static ServerSentEvent withEventId(ByteBuf eventId, ByteBuf data) {
        return new ServerSentEvent(eventId, null, data);
    }

    public static ServerSentEvent withEventType(ByteBuf eventType, ByteBuf data) {
        return new ServerSentEvent(null, eventType, data);
    }

    public static ServerSentEvent withEventIdAndType(ByteBuf eventId, ByteBuf eventType, ByteBuf data) {
        return new ServerSentEvent(eventId, eventType, data);
    }

    protected Charset getSseCharset() {
        return null == sseEncodingCharset ? Charset.forName("UTF-8") : sseEncodingCharset;
    }

    static {
        try {
            sseEncodingCharset = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            logger.error("UTF-8 charset not available. Since SSE only contains UTF-8 data, we can not read SSE data.");
            sseEncodingCharset = null;
        }
    }

    public static enum Type {
        Data,
        Id,
        EventType;

    }
}

