/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.websocket;

import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import iep.io.reactivex.netty.protocol.http.websocket.WebSocketClientMetricsEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;

public interface WebSocketClientMetricsHandlers {

    public static class ClientWriteMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;

        public ClientWriteMetricsHandler(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
            this.eventsSubject = eventsSubject;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.eventsSubject.onEvent(WebSocketClientMetricsEvent.WEB_SOCKET_FRAME_WRITES);
            super.write(ctx, msg, promise);
        }
    }

    public static class ClientReadMetricsHandler
    extends ChannelInboundHandlerAdapter {
        private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;

        public ClientReadMetricsHandler(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
            this.eventsSubject = eventsSubject;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.eventsSubject.onEvent(WebSocketClientMetricsEvent.WEB_SOCKET_FRAME_READS);
            super.channelRead(ctx, msg);
        }
    }
}

