/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.udp.client;

import iep.io.reactivex.netty.client.AbstractClientBuilder;
import iep.io.reactivex.netty.client.ClientChannelFactoryImpl;
import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.client.ConnectionPoolBuilder;
import iep.io.reactivex.netty.client.RxClient;
import iep.io.reactivex.netty.metrics.MetricEventsListener;
import iep.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import iep.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import iep.io.reactivex.netty.protocol.udp.client.UdpClient;
import iep.io.reactivex.netty.protocol.udp.client.UdpClientConnectionFactory;
import io.netty.bootstrap.Bootstrap;
import java.net.InetSocketAddress;

public class UdpClientBuilder<I, O>
extends AbstractClientBuilder<I, O, UdpClientBuilder<I, O>, RxClient<I, O>> {
    public UdpClientBuilder(String host, int port) {
        this(host, port, new Bootstrap());
    }

    public UdpClientBuilder(String host, int port, Bootstrap bootstrap) {
        super(bootstrap, host, port, new UdpClientConnectionFactory(new InetSocketAddress(host, port)), new ClientChannelFactoryImpl(bootstrap));
        this.defaultUdpOptions();
    }

    @Override
    protected RxClient<I, O> createClient() {
        return new UdpClient(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.eventsSubject);
    }

    @Override
    public UdpClientBuilder<I, O> withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        throw new IllegalArgumentException("SSL protocol is not applicable to UDP ");
    }

    @Override
    protected ConnectionPoolBuilder<O, I> getPoolBuilder(boolean createNew) {
        ConnectionPoolBuilder builder = super.getPoolBuilder(false);
        if (null == builder && createNew) {
            throw new IllegalStateException("Connection pools are not allowed for UDP clients.");
        }
        if (null != builder) {
            throw new IllegalStateException("Connection pools are not allowed for UDP clients.");
        }
        return builder;
    }

    @Override
    protected String generatedNamePrefix() {
        return "UdpClient-";
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, RxClient<I, O> client) {
        return factory.forUdpClient((UdpClient)client);
    }
}

