/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionLifecycleHandler;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.Clock;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.ssl.SslCompletionHandler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class ClientChannelFactoryImpl<I, O>
implements ClientChannelFactory<I, O> {
    protected final Bootstrap clientBootstrap;
    private MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;

    public ClientChannelFactoryImpl(Bootstrap clientBootstrap, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.clientBootstrap = clientBootstrap;
        this.eventsSubject = eventsSubject;
    }

    public ClientChannelFactoryImpl(Bootstrap clientBootstrap) {
        this(clientBootstrap, new MetricEventsSubject());
    }

    @Override
    public ChannelFuture connect(final Subscriber<? super ObservableConnection<I, O>> subscriber, RxClient.ServerInfo serverInfo, final ClientConnectionFactory<I, O, ? extends ObservableConnection<I, O>> connectionFactory) {
        final long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_START);
        final ChannelFuture connectFuture = this.clientBootstrap.connect(serverInfo.getHost(), serverInfo.getPort());
        subscriber.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (!connectFuture.isDone()) {
                    connectFuture.cancel(true);
                }
            }
        }));
        connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(final ChannelFuture future) throws Exception {
                try {
                    if (!future.isSuccess()) {
                        ClientChannelFactoryImpl.this._onConnectFailed(future.cause(), subscriber, startTimeMillis);
                    } else {
                        ChannelPipeline pipeline = future.channel().pipeline();
                        ChannelHandler lifecycleHandler = pipeline.get("conn_lifecycle_handler");
                        if (null == lifecycleHandler) {
                            ClientChannelFactoryImpl.this._newConnection(connectionFactory, future.channel(), subscriber, startTimeMillis);
                        } else {
                            ConnectionLifecycleHandler handler = (ConnectionLifecycleHandler)lifecycleHandler;
                            SslCompletionHandler sslHandler = (SslCompletionHandler)pipeline.get(SslCompletionHandler.class);
                            if (null == sslHandler) {
                                ObservableConnection conn = ClientChannelFactoryImpl.this._newConnection(connectionFactory, future.channel(), subscriber, startTimeMillis);
                                handler.setConnection(conn);
                            } else {
                                sslHandler.sslCompletionStatus().subscribe((Subscriber)new Subscriber<Void>(){

                                    public void onCompleted() {
                                        ClientChannelFactoryImpl.this._newConnection(connectionFactory, future.channel(), subscriber, startTimeMillis);
                                    }

                                    public void onError(Throwable e) {
                                        ClientChannelFactoryImpl.this._onConnectFailed(e, subscriber, startTimeMillis);
                                    }

                                    public void onNext(Void aVoid) {
                                    }
                                });
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    subscriber.onError(throwable);
                }
            }
        });
        return connectFuture;
    }

    @Override
    public void onNewConnection(ObservableConnection<I, O> newConnection, Subscriber<? super ObservableConnection<I, O>> subscriber) {
        subscriber.onNext(newConnection);
        subscriber.onCompleted();
    }

    @Override
    public void useMetricEventsSubject(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }

    private ObservableConnection<I, O> _newConnection(ClientConnectionFactory<I, O, ? extends ObservableConnection<I, O>> connectionFactory, Channel channel, Subscriber<? super ObservableConnection<I, O>> subscriber, long startTimeMillis) {
        ObservableConnection<I, O> newConnection = connectionFactory.newConnection(channel);
        this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_SUCCESS, Clock.onEndMillis(startTimeMillis));
        this.onNewConnection(newConnection, subscriber);
        return newConnection;
    }

    private void _onConnectFailed(Throwable cause, Subscriber<? super ObservableConnection<I, O>> subscriber, long startTimeMillis) {
        this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_FAILED, Clock.onEndMillis(startTimeMillis), cause);
        subscriber.onError(cause);
    }
}

