/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import mantis.io.reactivex.netty.channel.RxDefaultThreadFactory;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionPool;
import mantis.io.reactivex.netty.client.ConnectionPoolImpl;
import mantis.io.reactivex.netty.client.MaxConnectionsBasedStrategy;
import mantis.io.reactivex.netty.client.PoolConfig;
import mantis.io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import mantis.io.reactivex.netty.client.PooledConnection;
import mantis.io.reactivex.netty.client.PooledConnectionFactory;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;

public class ConnectionPoolBuilder<I, O> {
    private static final ScheduledExecutorService SHARED_IDLE_CLEANUP_SCHEDULER = Executors.newScheduledThreadPool(1, (ThreadFactory)((Object)new RxDefaultThreadFactory("global-client-idle-conn-cleanup-scheduler")));
    private final RxClient.ServerInfo serverInfo;
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    private ClientConnectionFactory<I, O, PooledConnection<I, O>> connectionFactory;
    private ClientChannelFactory<I, O> channelFactory;
    private PoolLimitDeterminationStrategy limitDeterminationStrategy = new MaxConnectionsBasedStrategy();
    private ScheduledExecutorService poolIdleCleanupScheduler = SHARED_IDLE_CLEANUP_SCHEDULER;
    private long idleConnectionsTimeoutMillis = PoolConfig.DEFAULT_CONFIG.getMaxIdleTimeMillis();

    public ConnectionPoolBuilder(RxClient.ServerInfo serverInfo, ClientChannelFactory<I, O> channelFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this(serverInfo, channelFactory, new PooledConnectionFactory(PoolConfig.DEFAULT_CONFIG, eventsSubject), eventsSubject);
    }

    public ConnectionPoolBuilder(RxClient.ServerInfo serverInfo, ClientChannelFactory<I, O> channelFactory, ClientConnectionFactory<I, O, PooledConnection<I, O>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        if (null == serverInfo) {
            throw new NullPointerException("Server info can not be null.");
        }
        if (null == channelFactory) {
            throw new NullPointerException("Channel factory can not be null.");
        }
        if (null == connectionFactory) {
            throw new NullPointerException("Connection factory can not be null.");
        }
        this.eventsSubject = eventsSubject;
        this.serverInfo = serverInfo;
        this.connectionFactory = connectionFactory;
        this.channelFactory = channelFactory;
    }

    public ConnectionPoolBuilder<I, O> withMaxConnections(int maxConnections) {
        this.limitDeterminationStrategy = new MaxConnectionsBasedStrategy(maxConnections);
        return this;
    }

    public ConnectionPoolBuilder<I, O> withIdleConnectionsTimeoutMillis(long idleConnectionsTimeoutMillis) {
        this.idleConnectionsTimeoutMillis = idleConnectionsTimeoutMillis;
        return this;
    }

    public ConnectionPoolBuilder<I, O> withConnectionPoolLimitStrategy(PoolLimitDeterminationStrategy strategy) {
        this.limitDeterminationStrategy = strategy;
        return this;
    }

    public ConnectionPoolBuilder<I, O> withPoolIdleCleanupScheduler(ScheduledExecutorService poolIdleCleanupScheduler) {
        this.poolIdleCleanupScheduler = poolIdleCleanupScheduler;
        return this;
    }

    public ConnectionPoolBuilder<I, O> withNoIdleConnectionCleanup() {
        this.poolIdleCleanupScheduler = null;
        return this;
    }

    public ConnectionPoolBuilder<I, O> withChannelFactory(ClientChannelFactory<I, O> factory) {
        this.channelFactory = factory;
        return this;
    }

    public ConnectionPoolBuilder<I, O> withConnectionFactory(ClientConnectionFactory<I, O, PooledConnection<I, O>> factory) {
        this.connectionFactory = factory;
        return this;
    }

    public ClientChannelFactory<I, O> getChannelFactory() {
        return this.channelFactory;
    }

    public ClientConnectionFactory<I, O, PooledConnection<I, O>> getConnectionFactory() {
        return this.connectionFactory;
    }

    public ConnectionPool<I, O> build() {
        PoolConfig poolConfig = new PoolConfig(this.idleConnectionsTimeoutMillis);
        return new ConnectionPoolImpl<I, O>(this.serverInfo, poolConfig, this.limitDeterminationStrategy, this.poolIdleCleanupScheduler, this.connectionFactory, this.channelFactory, this.eventsSubject);
    }

    public ConnectionPoolBuilder<I, O> copy(RxClient.ServerInfo serverInfo) {
        ConnectionPoolBuilder<I, O> copy = new ConnectionPoolBuilder<I, O>(serverInfo, this.channelFactory, this.connectionFactory, this.eventsSubject);
        copy.withIdleConnectionsTimeoutMillis(this.idleConnectionsTimeoutMillis).withPoolIdleCleanupScheduler(this.poolIdleCleanupScheduler).withConnectionPoolLimitStrategy(this.limitDeterminationStrategy);
        return copy;
    }

    public long getIdleConnectionsTimeoutMillis() {
        return this.idleConnectionsTimeoutMillis;
    }

    public PoolLimitDeterminationStrategy getLimitDeterminationStrategy() {
        return this.limitDeterminationStrategy;
    }

    public ScheduledExecutorService getPoolIdleCleanupScheduler() {
        return this.poolIdleCleanupScheduler;
    }
}

