/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.websocket;

import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.MetricsEvent;

public class WebSocketClientMetricsEvent<T extends Enum<T>>
extends ClientMetricsEvent<T> {
    public static final WebSocketClientMetricsEvent<EventType> HANDSHAKE_START = WebSocketClientMetricsEvent.from(EventType.HandshakeStart);
    public static final WebSocketClientMetricsEvent<EventType> HANDSHAKE_SUCCESS = WebSocketClientMetricsEvent.from(EventType.HandshakeSuccess);
    public static final WebSocketClientMetricsEvent<EventType> HANDSHAKE_FAILURE = WebSocketClientMetricsEvent.from(EventType.HandshakeFailure);
    public static final WebSocketClientMetricsEvent<EventType> WEB_SOCKET_FRAME_WRITES = WebSocketClientMetricsEvent.from(EventType.WebSocketFrameWrites);
    public static final WebSocketClientMetricsEvent<EventType> WEB_SOCKET_FRAME_READS = WebSocketClientMetricsEvent.from(EventType.WebSocketFrameReads);

    protected WebSocketClientMetricsEvent(T type, boolean isTimed, boolean isError) {
        super(type, isTimed, isError);
    }

    private static WebSocketClientMetricsEvent<EventType> from(EventType type) {
        return new WebSocketClientMetricsEvent<EventType>(type, type.isTimed(), type.isError());
    }

    public static enum EventType implements MetricsEvent.MetricEventType
    {
        HandshakeStart(false, false, Void.class),
        HandshakeSuccess(true, false, Void.class),
        HandshakeFailure(true, true, Void.class),
        WebSocketFrameWrites(false, false, Void.class),
        WebSocketFrameReads(false, false, Void.class);

        private final boolean isTimed;
        private final boolean isError;
        private final Class<?> optionalDataType;

        private EventType(boolean isTimed, boolean isError, Class<?> optionalDataType) {
            this.isTimed = isTimed;
            this.isError = isError;
            this.optionalDataType = optionalDataType;
        }

        @Override
        public boolean isTimed() {
            return this.isTimed;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }

        @Override
        public Class<?> getOptionalDataType() {
            return this.optionalDataType;
        }
    }
}

