/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketClientHandler;

public class WebSocketClientPipelineConfigurator<R, W>
implements PipelineConfigurator<R, W> {
    private final URI webSocketURI;
    private final WebSocketVersion webSocketVersion;
    private final String subprotocol;
    private final boolean allowExtensions;
    private final int maxFramePayloadLength;
    private final boolean messageAggregation;
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;

    public WebSocketClientPipelineConfigurator(URI webSocketURI, WebSocketVersion webSocketVersion, String subprotocol, boolean allowExtensions, int maxFramePayloadLength, boolean messageAggregation, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.webSocketURI = webSocketURI;
        this.webSocketVersion = webSocketVersion;
        this.subprotocol = subprotocol;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.messageAggregation = messageAggregation;
        this.eventsSubject = eventsSubject;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)this.webSocketURI, (WebSocketVersion)this.webSocketVersion, (String)this.subprotocol, (boolean)this.allowExtensions, (HttpHeaders)new DefaultHttpHeaders(), (int)this.maxFramePayloadLength);
        WebSocketClientHandler handler = new WebSocketClientHandler(handshaker, this.maxFramePayloadLength, this.messageAggregation, this.eventsSubject);
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
        pipeline.addLast(new ChannelHandler[]{handler});
    }
}

