/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.atlas;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.servo.Metric;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.atlas.JsonPayload;
import com.netflix.servo.publish.atlas.ValidCharacters;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.util.Objects;
import com.netflix.servo.util.Preconditions;
import java.io.IOException;

class AtlasMetric
implements JsonPayload {
    private final MonitorConfig config;
    private final long start;
    private final double value;

    AtlasMetric(Metric m) {
        this(m.getConfig(), m.getTimestamp(), m.getNumberValue());
    }

    AtlasMetric(MonitorConfig config, long start, Number value) {
        this.config = (MonitorConfig)Preconditions.checkNotNull((Object)config, (String)"config");
        this.value = ((Number)Preconditions.checkNotNull((Object)value, (String)"value")).doubleValue();
        this.start = start;
    }

    MonitorConfig getConfig() {
        return this.config;
    }

    long getStartTime() {
        return this.start;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasMetric)) {
            return false;
        }
        AtlasMetric m = (AtlasMetric)obj;
        return this.config.equals((Object)m.getConfig()) && this.start == m.getStartTime() && Double.compare(this.value, m.value) == 0;
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.config, this.start, this.value});
    }

    public String toString() {
        return "AtlasMetric{config=" + this.config + ", start=" + this.start + ", value=" + this.value + '}';
    }

    @Override
    public void toJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", this.config.getName());
        for (Tag tag : this.config.getTags()) {
            ValidCharacters.tagToJson(gen, tag);
        }
        gen.writeEndObject();
        gen.writeNumberField("start", this.start);
        gen.writeNumberField("value", this.value);
        gen.writeEndObject();
        gen.flush();
    }
}

