/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.atlas;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.atlas.AtlasMetric;
import com.netflix.servo.publish.atlas.JsonPayload;
import com.netflix.servo.publish.atlas.ValidCharacters;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Objects;
import com.netflix.servo.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class UpdateRequest
implements JsonPayload {
    private final TagList tags;
    private final List<AtlasMetric> metrics;

    public UpdateRequest(TagList tags, Metric[] metricsToSend, int numMetrics) {
        Preconditions.checkArgument((metricsToSend.length > 0 ? 1 : 0) != 0, (String)"metricsToSend is empty");
        Preconditions.checkArgument((numMetrics > 0 && numMetrics <= metricsToSend.length ? 1 : 0) != 0, (String)"numMetrics is 0 or out of bounds");
        this.metrics = new ArrayList<AtlasMetric>(numMetrics);
        for (int i = 0; i < numMetrics; ++i) {
            Metric m = metricsToSend[i];
            if (!m.hasNumberValue()) continue;
            this.metrics.add(new AtlasMetric(m));
        }
        this.tags = tags;
    }

    TagList getTags() {
        return this.tags;
    }

    List<AtlasMetric> getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateRequest)) {
            return false;
        }
        UpdateRequest req = (UpdateRequest)obj;
        return this.tags.equals(req.getTags()) && this.metrics.equals(req.getMetrics());
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.tags, this.metrics});
    }

    public String toString() {
        return "UpdateRequest{tags=" + this.tags + ", metrics=" + this.metrics + '}';
    }

    @Override
    public void toJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        for (Tag tag : this.tags) {
            ValidCharacters.tagToJson(gen, tag);
        }
        gen.writeEndObject();
        gen.writeArrayFieldStart("metrics");
        for (AtlasMetric m : this.metrics) {
            m.toJson(gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.flush();
    }
}

