/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class IdMapper
implements Function<Id, Map<String, String>> {
    private final Function<String, String> fixTagString;

    public IdMapper(Function<String, String> fixTagString) {
        this.fixTagString = fixTagString;
    }

    @Override
    public Map<String, String> apply(Id id) {
        int size = id.size();
        HashMap<String, String> tags = new HashMap<String, String>(size);
        for (int i = 1; i < size; ++i) {
            String k = this.fixTagString.apply(id.getKey(i));
            String v = this.fixTagString.apply(id.getValue(i));
            tags.put(k, v);
        }
        String name = this.fixTagString.apply(id.name());
        tags.put("name", name);
        return tags;
    }
}

