/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.sasl;

import com.netscape.sasl.SaslClient;
import com.netscape.sasl.SaslClientFactory;
import com.netscape.sasl.SaslException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

public class Sasl {
    private static SaslClientFactory clientFactory = null;
    static final boolean debug = false;
    public static final String CLIENTPKGS = "javax.security.sasl.client.pkgs";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Hashtable props, CallbackHandler cbh) throws SaslException {
        SaslClient mech = null;
        if (clientFactory != null) {
            mech = clientFactory.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        }
        if (mech == null) {
            String pkgs;
            String string = pkgs = props == null ? null : (String)props.get(CLIENTPKGS);
            if (pkgs != null) {
                mech = Sasl.loadFromPkgList(pkgs, mechanisms, authorizationId, protocol, serverName, props, cbh);
            }
            if (mech == null && (pkgs = System.getProperty(CLIENTPKGS)) != null) {
                mech = Sasl.loadFromPkgList(pkgs, mechanisms, authorizationId, protocol, serverName, props, cbh);
            }
        }
        return mech;
    }

    private static SaslClient loadFromPkgList(String pkgs, String[] mechanisms, String authorizationId, String protocol, String serverName, Hashtable props, CallbackHandler cbh) throws SaslException {
        StringTokenizer packagePrefixIter = new StringTokenizer(pkgs, "|");
        SaslClient mech = null;
        SaslClientFactory fac = null;
        while (mech == null && packagePrefixIter.hasMoreTokens()) {
            String pkg = packagePrefixIter.nextToken().trim();
            String clsName = pkg + ".ClientFactory";
            Class<?> cls = null;
            try {
                cls = Class.forName(clsName);
            }
            catch (Exception e) {
                System.err.println("Sasl.loadFromPkgList: " + e);
            }
            if (cls == null) continue;
            try {
                fac = (SaslClientFactory)cls.newInstance();
            }
            catch (InstantiationException e) {
                throw new SaslException("Cannot instantiate " + clsName);
            }
            catch (IllegalAccessException e) {
                throw new SaslException("Cannot access constructor of " + clsName);
            }
            mech = fac.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        }
        return mech;
    }

    public static void setSaslClientFactory(SaslClientFactory fac) {
        if (clientFactory != null) {
            throw new IllegalStateException("SaslClientFactory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        clientFactory = fac;
    }
}

