/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public abstract class BERCharacterString
extends BERElement {
    protected String m_value = null;
    private byte[] byte_buf;

    public BERCharacterString() {
    }

    public BERCharacterString(String string) {
        this.m_value = string;
    }

    public BERCharacterString(byte[] buffer) {
        try {
            this.m_value = new String(buffer, "UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BERCharacterString(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length;
        int[] component_length = new int[1];
        BERElement element = null;
        if (contents_length == -1) {
            do {
                component_length[0] = 0;
                element = BERCharacterString.getElement(decoder, stream, component_length);
                if (element == null) continue;
                BERCharacterString octet_element = (BERCharacterString)element;
                String string_buffer = octet_element.getValue();
                this.m_value = this.m_value == null ? string_buffer : this.m_value + string_buffer;
            } while (element != null);
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            for (contents_length = BERElement.readLengthOctets(stream, bytes_read); contents_length > 0; contents_length -= component_length[0]) {
                component_length[0] = 0;
                element = BERCharacterString.getElement(decoder, stream, component_length);
                if (element == null) continue;
                BERCharacterString octet_element = (BERCharacterString)element;
                String string_buffer = octet_element.getValue();
                this.m_value = this.m_value == null ? string_buffer : this.m_value + string_buffer;
            }
        }
    }

    public BERCharacterString(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        if (contents_length > 0) {
            byte[] buffer = new byte[contents_length];
            for (int i = 0; i < contents_length; ++i) {
                buffer[i] = (byte)stream.read();
            }
            bytes_read[0] = bytes_read[0] + contents_length;
            try {
                this.m_value = new String(buffer, "UTF8");
            }
            catch (Throwable x) {
                // empty catch block
            }
        }
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.getType());
        if (this.m_value == null) {
            BERCharacterString.sendDefiniteLength(stream, 0);
        } else {
            try {
                this.byte_buf = this.m_value.getBytes("UTF8");
                BERCharacterString.sendDefiniteLength(stream, this.byte_buf.length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stream.write(this.byte_buf, 0, this.byte_buf.length);
        }
    }

    public String getValue() {
        return this.m_value;
    }

    public abstract int getType();

    public abstract String toString();
}

