/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.JDAPFilterOpers;

public class JDAPFilterSubString
extends JDAPFilter {
    private String m_type = null;
    private Vector m_initial = new Vector();
    private Vector m_any = new Vector();
    private Vector m_final = new Vector();

    public JDAPFilterSubString(String type) {
        this.m_type = type;
    }

    public void addInitial(String s) {
        this.m_initial.addElement(s);
    }

    public void addAny(String s) {
        this.m_any.addElement(s);
    }

    public void addFinal(String s) {
        this.m_final.addElement(s);
    }

    public BERElement getBERElement() {
        BERTag str;
        String val;
        int i;
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_type));
        BERSequence str_seq = new BERSequence();
        for (i = 0; i < this.m_initial.size(); ++i) {
            val = (String)this.m_initial.elementAt(i);
            if (val == null) continue;
            str = new BERTag(128, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        for (i = 0; i < this.m_any.size(); ++i) {
            val = (String)this.m_any.elementAt(i);
            if (val == null) continue;
            str = new BERTag(129, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        for (i = 0; i < this.m_final.size(); ++i) {
            val = (String)this.m_final.elementAt(i);
            if (val == null) continue;
            str = new BERTag(130, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        seq.addElement(str_seq);
        BERTag element = new BERTag(164, seq, true);
        return element;
    }

    public String toString() {
        String initial = "";
        for (int i = 0; i < this.m_initial.size(); ++i) {
            if (i != 0) {
                initial = initial + ",";
            }
            initial = initial + (String)this.m_initial.elementAt(i);
        }
        String any = "";
        for (int i = 0; i < this.m_any.size(); ++i) {
            if (i != 0) {
                any = any + ",";
            }
            any = any + (String)this.m_any.elementAt(i);
        }
        String s_final = "";
        for (int i = 0; i < this.m_final.size(); ++i) {
            if (i != 0) {
                s_final = s_final + ",";
            }
            s_final = s_final + (String)this.m_final.elementAt(i);
        }
        return "JDAPFilterSubString {type=" + this.m_type + ", initial=" + initial + ", any=" + any + ", final=" + s_final + "}";
    }
}

