/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.JDAPFilterOpers;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    public static final int BASE_OBJECT = 0;
    public static final int SINGLE_LEVEL = 1;
    public static final int WHOLE_SUBTREE = 2;
    public static final int NEVER_DEREF_ALIASES = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    protected String m_base_dn = null;
    protected int m_scope;
    protected int m_deref;
    protected int m_size_limit;
    protected int m_time_limit;
    protected boolean m_attrs_only;
    protected String m_filter = null;
    protected JDAPFilter m_parsedFilter = null;
    protected String[] m_attrs = null;

    public JDAPSearchRequest(String base_dn, int scope, int deref, int size_limit, int time_limit, boolean attrs_only, String filter, String[] attrs) throws IllegalArgumentException {
        this.m_base_dn = base_dn;
        this.m_scope = scope;
        this.m_deref = deref;
        this.m_size_limit = size_limit;
        this.m_time_limit = time_limit;
        this.m_attrs_only = attrs_only;
        this.m_filter = filter == null ? DEFAULT_FILTER : filter;
        this.m_parsedFilter = JDAPFilter.getFilter(JDAPFilterOpers.convertLDAPv2Escape(this.m_filter));
        if (this.m_parsedFilter == null) {
            throw new IllegalArgumentException("Bad search filter");
        }
        this.m_attrs = attrs;
    }

    public int getType() {
        return 3;
    }

    public void setBaseDN(String basedn) {
        this.m_base_dn = basedn;
    }

    public String getBaseDN() {
        return this.m_base_dn;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_base_dn));
        seq.addElement(new BEREnumerated(this.m_scope));
        seq.addElement(new BEREnumerated(this.m_deref));
        seq.addElement(new BERInteger(this.m_size_limit));
        seq.addElement(new BERInteger(this.m_time_limit));
        seq.addElement(new BERBoolean(this.m_attrs_only));
        seq.addElement(this.m_parsedFilter.getBERElement());
        BERSequence attr_type_list = new BERSequence();
        if (this.m_attrs != null) {
            for (int i = 0; i < this.m_attrs.length; ++i) {
                attr_type_list.addElement(new BEROctetString(this.m_attrs[i]));
            }
        }
        seq.addElement(attr_type_list);
        BERTag element = new BERTag(99, seq, true);
        return element;
    }

    public String toString() {
        String s = null;
        if (this.m_attrs != null) {
            s = "";
            for (int i = 0; i < this.m_attrs.length; ++i) {
                if (i != 0) {
                    s = s + "+";
                }
                s = s + this.m_attrs[i];
            }
        }
        return "SearchRequest {baseObject=" + this.m_base_dn + ", scope=" + this.m_scope + ", derefAliases=" + this.m_deref + ",sizeLimit=" + this.m_size_limit + ", timeLimit=" + this.m_time_limit + ", attrsOnly=" + this.m_attrs_only + ", filter=" + this.m_filter + ", attributes=" + s + "}";
    }
}

