/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentImpl;
import com.newrelic.agent.AsyncApiImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.attributes.AgentAttributeSender;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PrivateApi;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.jmx.JmxApiImpl;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.AgentCollectionFactory;
import com.newrelic.api.agent.Logger;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;

public class PrivateApiImpl
implements PrivateApi {
    private final AttributeSender attributeSender = new AgentAttributeSender();

    public static void initialize(Logger logger) {
        PrivateApiImpl api = new PrivateApiImpl();
        AgentBridge.privateApi = api;
        AgentBridge.asyncApi = new AsyncApiImpl(logger);
        AgentBridge.jmxApi = new JmxApiImpl();
        AgentBridge.collectionFactory = new AgentCollectionFactory();
        AgentBridge.agent = new AgentImpl(logger);
    }

    public Closeable addSampler(Runnable sampler, int period, TimeUnit timeUnit) {
        return ServiceFactory.getSamplerService().addSampler(sampler, period, timeUnit);
    }

    public void setServerInfo(String serverInfo) {
        Environment env = ServiceFactory.getEnvironmentService().getEnvironment();
        if (!env.getAgentIdentity().isServerInfoSet()) {
            env.setServerInfo(serverInfo);
        }
    }

    public void addMBeanServer(MBeanServer server) {
        ServiceFactory.getJmxService().setJmxServer(server);
    }

    public void removeMBeanServer(MBeanServer serverToRemove) {
        ServiceFactory.getJmxService().removeJmxServer(serverToRemove);
    }

    public void addCustomAttribute(String key, String value) {
        this.attributeSender.addAttribute(key, value, "addCustomAttribute");
    }

    public void addCustomAttribute(String key, Number value) {
        this.attributeSender.addAttribute(key, value, "addCustomAttribute");
    }

    public void addCustomAttribute(String key, Map<String, String> values) {
        this.attributeSender.addAttribute(key, values, "addCustomAttribute");
    }

    public void addTracerParameter(String key, Number value) {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            currentTxn.getTransactionActivity().getLastTracer().setAgentAttribute(key, value);
        }
    }

    public void reportHTTPError(String message, int statusCode, String uri) {
        ServiceFactory.getRPMService().getErrorService().reportHTTPError(message, statusCode, uri);
    }

    public void reportException(Throwable throwable) {
        ServiceFactory.getRPMService().getErrorService().reportException(throwable);
    }

    public void setAppServerPort(int port) {
        AgentBridge.publicApi.setAppServerPort(port);
    }

    public void setServerInfo(String dispatcherName, String version) {
        AgentBridge.publicApi.setServerInfo(dispatcherName, version);
    }

    public void setInstanceName(String instanceName) {
        AgentBridge.publicApi.setInstanceName(instanceName);
    }

    public void addTracerParameter(String key, String value) {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            currentTxn.getTransactionActivity().getLastTracer().setAgentAttribute(key, value);
        }
    }

    public void addTracerParameter(String key, String value, boolean addToSpan) {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            currentTxn.getTransactionActivity().getLastTracer().setAgentAttribute(key, value, addToSpan);
        }
    }

    public void addTracerParameter(String key, Map<String, String> values) {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            currentTxn.getTransactionActivity().getLastTracer().setAgentAttribute(key, values);
        }
    }
}

