/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.attributes.DefaultDestinationPredicate;
import com.newrelic.agent.attributes.DestinationPredicate;
import com.newrelic.agent.attributes.DisabledDestinationPredicate;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfig;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class DestinationFilter {
    private final boolean isEnabled;
    private final DestinationPredicate filter;

    public DestinationFilter(String mainNameForFilter, boolean defaultInclude, AgentConfig config, String[] defaultExclude, String ... namesForIsEnabled) {
        this.isEnabled = config.getAttributesConfig().isAttsEnabled(config, defaultInclude, namesForIsEnabled);
        Agent.LOG.log(Level.FINE, "Attributes are {0} for {1}", this.isEnabled ? "enabled" : "disabled", mainNameForFilter);
        AttributesConfig attributesConfig = config.getAttributesConfig();
        List<String> rootExcludes = attributesConfig.attributesRootExclude();
        List<String> rootIncludes = attributesConfig.attributesRootInclude();
        this.filter = DestinationFilter.getDestinationPredicate(this.isEnabled, config, rootExcludes, rootIncludes, mainNameForFilter, DestinationFilter.updateDefaults(defaultExclude));
    }

    private static DestinationPredicate getDestinationPredicate(boolean isEnabled, AgentConfig config, List<String> rootExcludes, List<String> rootIncludes, String name, Set<String> defaultExclude) {
        if (isEnabled) {
            Set<String> configExclude = DestinationFilter.getExcluded(config, rootExcludes, name);
            Set<String> configInclude = Collections.emptySet();
            if (!config.isHighSecurity()) {
                configInclude = DestinationFilter.getIncluded(config, rootIncludes, name);
            }
            return new DefaultDestinationPredicate(name, configExclude, configInclude, defaultExclude, DestinationFilter.getMandatoryExcludes(config));
        }
        return new DisabledDestinationPredicate();
    }

    private static Set<String> getMandatoryExcludes(AgentConfig config) {
        HashSet<String> excludes = new HashSet<String>();
        if (config.isHighSecurity()) {
            excludes.add("message.parameters.*");
            excludes.add("request.parameters.*");
        }
        return excludes;
    }

    private static Set<String> updateDefaults(String[] defaultExclude) {
        HashSet<String> defaultExc = Sets.newHashSet(defaultExclude);
        defaultExc.add("request.parameters.*");
        defaultExc.add("message.parameters.*");
        return defaultExc;
    }

    protected static Set<String> getExcluded(AgentConfig config, List<String> baseList, String dest) {
        HashSet<String> output = new HashSet<String>();
        output.addAll(baseList);
        output.addAll(DestinationFilter.getBaseList(config, dest + "." + "attributes.exclude"));
        return output;
    }

    protected static Set<String> getIncluded(AgentConfig config, List<String> baseList, String dest) {
        HashSet<String> output = new HashSet<String>();
        output.addAll(baseList);
        output.addAll(DestinationFilter.getBaseList(config, dest + "." + "attributes.include"));
        return output;
    }

    protected static List<String> getBaseList(AgentConfig config, String key) {
        Object val = config.getValue(key);
        if (val instanceof String) {
            return BaseConfig.getUniqueStringsFromString((String)val, ",");
        }
        if (val instanceof Collection) {
            return BaseConfig.getUniqueStringsFromCollection((Collection)val, null);
        }
        return Collections.emptyList();
    }

    protected boolean isPotentialConfigMatch(String paramStart) {
        return this.filter.isPotentialConfigMatch(paramStart);
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected Map<String, ?> filterAttributes(Map<String, ?> values) {
        return this.filterAttributes(values, this.filter);
    }

    private Map<String, ?> filterAttributes(Map<String, ?> values, DestinationPredicate predicate) {
        return this.isEnabled && values != null && !values.isEmpty() ? Maps.filterKeys(values, predicate) : Collections.emptyMap();
    }

    public boolean shouldIncludeAttribute(String attributeName) {
        return this.filter.apply(attributeName);
    }
}

