/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.util.Map;

public class SuperAgentIntegrationHealthConfig
extends BaseConfig {
    public static final String ROOT = "health";
    public static final String FREQUENCY = "frequency";
    public static final int FREQUENCY_DEFAULT = 5;
    public static final String LOCATION = "delivery_location";
    private final int frequency = this.getProperty("frequency", 5);
    private URI deliveryLocation;
    private String healthClientType;

    public SuperAgentIntegrationHealthConfig(Map<String, Object> props, String systemPropertyPrefix) {
        super(props, systemPropertyPrefix + ROOT + ".");
        this.validateAndAssignLocationUri((String)this.getProperty(LOCATION));
    }

    public int getHealthReportingFrequency() {
        return this.frequency;
    }

    public URI getHealthDeliveryLocation() {
        return this.deliveryLocation;
    }

    public String getHealthClientType() {
        return this.healthClientType;
    }

    private void validateAndAssignLocationUri(String locationAsUri) {
        if (StringUtils.isNotEmpty(locationAsUri)) {
            try {
                this.deliveryLocation = new URI(locationAsUri);
            }
            catch (Exception e) {
                this.deliveryLocation = null;
                return;
            }
            this.healthClientType = this.deliveryLocation.getScheme();
            if (StringUtils.isAnyEmpty(this.healthClientType, this.deliveryLocation.getPath())) {
                this.deliveryLocation = null;
            }
        }
    }
}

