/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.okhttp.internal;

import com.newrelic.agent.deps.io.grpc.okhttp.internal.OptionalMethod;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.Protocol;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.Util;
import com.newrelic.agent.deps.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public class Platform {
    public static final Logger logger;
    private static final String[] ANDROID_SECURITY_PROVIDERS;
    private static final Platform PLATFORM;
    private final Provider sslProvider;

    public static Platform get() {
        return PLATFORM;
    }

    public Platform(Provider sslProvider) {
        this.sslProvider = sslProvider;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String warning) {
        System.out.println(warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public Provider getProvider() {
        return this.sslProvider;
    }

    public TlsExtensionType getTlsExtensionType() {
        return TlsExtensionType.NONE;
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    private static Platform findPlatform() {
        Provider sslProvider;
        Provider androidOrAppEngineProvider = Platform.getAndroidSecurityProvider();
        if (androidOrAppEngineProvider != null) {
            OptionalMethod<Socket> setUseSessionTickets = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> setHostname = new OptionalMethod<Socket>(null, "setHostname", String.class);
            Method trafficStatsTagSocket = null;
            Method trafficStatsUntagSocket = null;
            OptionalMethod<Socket> getAlpnSelectedProtocol = new OptionalMethod<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
            OptionalMethod<Socket> setAlpnProtocols = new OptionalMethod<Socket>(null, "setAlpnProtocols", byte[].class);
            try {
                Class<?> trafficStats = Class.forName("com.newrelic.agent.deps.android.net.TrafficStats");
                trafficStatsTagSocket = trafficStats.getMethod("tagSocket", Socket.class);
                trafficStatsUntagSocket = trafficStats.getMethod("untagSocket", Socket.class);
            }
            catch (ClassNotFoundException trafficStats) {
            }
            catch (NoSuchMethodException trafficStats) {
                // empty catch block
            }
            TlsExtensionType tlsExtensionType = androidOrAppEngineProvider.getName().equals("GmsCore_OpenSSL") || androidOrAppEngineProvider.getName().equals("Conscrypt") || androidOrAppEngineProvider.getName().equals("Ssl_Guard") ? TlsExtensionType.ALPN_AND_NPN : (Platform.isAtLeastAndroid5() ? TlsExtensionType.ALPN_AND_NPN : (Platform.isAtLeastAndroid41() ? TlsExtensionType.NPN : TlsExtensionType.NONE));
            return new Android(setUseSessionTickets, setHostname, trafficStatsTagSocket, trafficStatsUntagSocket, getAlpnSelectedProtocol, setAlpnProtocols, androidOrAppEngineProvider, tlsExtensionType);
        }
        try {
            sslProvider = SSLContext.getDefault().getProvider();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        try {
            SSLContext context = SSLContext.getInstance("TLS", sslProvider);
            context.init(null, null, null);
            SSLEngine engine = context.createSSLEngine();
            Method getEngineApplicationProtocol = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            getEngineApplicationProtocol.invoke((Object)engine, new Object[0]);
            Method setApplicationProtocols = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                }
            });
            Method getApplicationProtocol = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            return new JdkAlpnPlatform(sslProvider, setApplicationProtocols, getApplicationProtocol);
        }
        catch (NoSuchAlgorithmException context) {
        }
        catch (KeyManagementException context) {
        }
        catch (PrivilegedActionException context) {
        }
        catch (IllegalAccessException context) {
        }
        catch (InvocationTargetException context) {
            // empty catch block
        }
        try {
            String negoClassName = "org.eclipse.jetty.alpn.ALPN";
            Class<?> negoClass = Class.forName(negoClassName);
            Class<?> providerClass = Class.forName(negoClassName + "$Provider");
            Class<?> clientProviderClass = Class.forName(negoClassName + "$ClientProvider");
            Class<?> serverProviderClass = Class.forName(negoClassName + "$ServerProvider");
            Method putMethod = negoClass.getMethod("put", SSLSocket.class, providerClass);
            Method getMethod = negoClass.getMethod("get", SSLSocket.class);
            Method removeMethod = negoClass.getMethod("remove", SSLSocket.class);
            return new JdkWithJettyBootPlatform(putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass, sslProvider);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new Platform(sslProvider);
    }

    private static boolean isAtLeastAndroid5() {
        try {
            Platform.class.getClassLoader().loadClass("com.newrelic.agent.deps.android.net.Network");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Can't find class", e);
            return false;
        }
    }

    private static boolean isAtLeastAndroid41() {
        try {
            Platform.class.getClassLoader().loadClass("com.newrelic.agent.deps.android.app.ActivityOptions");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Can't find class", e);
            return false;
        }
    }

    private static Provider getAndroidSecurityProvider() {
        Provider[] providers;
        for (Provider availableProvider : providers = Security.getProviders()) {
            for (String providerClassName : ANDROID_SECURITY_PROVIDERS) {
                if (!providerClassName.equals(availableProvider.getClass().getName())) continue;
                logger.log(Level.FINE, "Found registered provider {0}", providerClassName);
                return availableProvider;
            }
        }
        logger.log(Level.WARNING, "Unable to find Conscrypt");
        return null;
    }

    public static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result.writeByte(protocol.toString().length());
            result.writeUtf8(protocol.toString());
        }
        return result.readByteArray();
    }

    static {
        Platform.class.getName();
        logger = Logger.global;
        ANDROID_SECURITY_PROVIDERS = new String[]{"com.newrelic.agent.deps.com.google.android.gms.org.conscrypt.OpenSSLProvider", "com.newrelic.agent.deps.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLProvider", "org.apache.harmony.xnet.provider.jsse.OpenSSLProvider", "com.newrelic.agent.deps.com.google.android.libraries.stitch.sslguard.SslGuardProvider"};
        PLATFORM = Platform.findPlatform();
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNegoProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (methodName.equals("supports") && Boolean.TYPE == returnType) {
                return true;
            }
            if (methodName.equals("unsupported") && Void.TYPE == returnType) {
                this.unsupported = true;
                return null;
            }
            if (methodName.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if ((methodName.equals("selectProtocol") || methodName.equals("select")) && String.class == returnType && args.length == 1 && args[0] instanceof List) {
                List peerProtocols = (List)args[0];
                int size = peerProtocols.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.protocols.contains(peerProtocols.get(i))) continue;
                    this.selected = (String)peerProtocols.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((methodName.equals("protocolSelected") || methodName.equals("selected")) && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }

    private static class JdkWithJettyBootPlatform
    extends Platform {
        private final Method putMethod;
        private final Method getMethod;
        private final Method removeMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass, Provider provider) {
            super(provider);
            this.putMethod = putMethod;
            this.getMethod = getMethod;
            this.removeMethod = removeMethod;
            this.clientProviderClass = clientProviderClass;
            this.serverProviderClass = serverProviderClass;
        }

        @Override
        public TlsExtensionType getTlsExtensionType() {
            return TlsExtensionType.ALPN_AND_NPN;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            ArrayList<String> names = new ArrayList<String>(protocols.size());
            int size = protocols.size();
            for (int i = 0; i < size; ++i) {
                Protocol protocol = protocols.get(i);
                if (protocol == Protocol.HTTP_1_0) continue;
                names.add(protocol.toString());
            }
            try {
                Object provider = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(names));
                this.putMethod.invoke(null, sslSocket, provider);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void afterHandshake(SSLSocket sslSocket) {
            try {
                this.removeMethod.invoke(null, sslSocket);
            }
            catch (IllegalAccessException ignored) {
                throw new AssertionError();
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.FINE, "Failed to remove SSLSocket from Jetty ALPN", ex);
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            try {
                JettyNegoProvider provider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
                if (!provider.unsupported && provider.selected == null) {
                    logger.log(Level.INFO, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                return provider.unsupported ? null : provider.selected;
            }
            catch (InvocationTargetException e) {
                throw new AssertionError();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
    }

    private static class JdkAlpnPlatform
    extends Platform {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        private JdkAlpnPlatform(Provider provider, Method setApplicationProtocols, Method getApplicationProtocol) {
            super(provider);
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        @Override
        public TlsExtensionType getTlsExtensionType() {
            return TlsExtensionType.ALPN_AND_NPN;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            SSLParameters parameters = sslSocket.getSSLParameters();
            ArrayList<String> names = new ArrayList<String>(protocols.size());
            for (Protocol protocol : protocols) {
                if (protocol == Protocol.HTTP_1_0) continue;
                names.add(protocol.toString());
            }
            try {
                this.setApplicationProtocols.invoke((Object)parameters, new Object[]{names.toArray(new String[names.size()])});
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            sslSocket.setSSLParameters(parameters);
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            try {
                return (String)this.getApplicationProtocol.invoke((Object)socket, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Android
    extends Platform {
        private final OptionalMethod<Socket> setUseSessionTickets;
        private final OptionalMethod<Socket> setHostname;
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;
        private final OptionalMethod<Socket> getAlpnSelectedProtocol;
        private final OptionalMethod<Socket> setAlpnProtocols;
        private final TlsExtensionType tlsExtensionType;

        public Android(OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, Method trafficStatsTagSocket, Method trafficStatsUntagSocket, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols, Provider provider, TlsExtensionType tlsExtensionType) {
            super(provider);
            this.setUseSessionTickets = setUseSessionTickets;
            this.setHostname = setHostname;
            this.trafficStatsTagSocket = trafficStatsTagSocket;
            this.trafficStatsUntagSocket = trafficStatsUntagSocket;
            this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
            this.setAlpnProtocols = setAlpnProtocols;
            this.tlsExtensionType = tlsExtensionType;
        }

        @Override
        public TlsExtensionType getTlsExtensionType() {
            return this.tlsExtensionType;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
            try {
                socket.connect(address, connectTimeout);
            }
            catch (SecurityException se) {
                IOException ioException = new IOException("Exception in connect");
                ioException.initCause(se);
                throw ioException;
            }
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            if (hostname != null) {
                this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sslSocket, true);
                this.setHostname.invokeOptionalWithoutCheckedException(sslSocket, hostname);
            }
            if (this.setAlpnProtocols.isSupported(sslSocket)) {
                Object[] parameters = new Object[]{Android.concatLengthPrefixed(protocols)};
                this.setAlpnProtocols.invokeWithoutCheckedException(sslSocket, parameters);
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (!this.getAlpnSelectedProtocol.isSupported(socket)) {
                return null;
            }
            byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(socket, new Object[0]);
            return alpnResult != null ? new String(alpnResult, Util.UTF_8) : null;
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static enum TlsExtensionType {
        ALPN_AND_NPN,
        NPN,
        NONE;

    }
}

