/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.discovery;

import com.newrelic.agent.deps.org.json.simple.JSONAware;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class AgentArguments
implements JSONAware {
    public static final String NEW_RELIC_APP_NAME_ENV_VARIABLE = "NEW_RELIC_APP_NAME";
    public static final String NEW_RELIC_COMMAND_LINE_ENV_VARIABLE = "NEW_RELIC_COMMAND_LINE";
    private static final String SYSTEM_PROPERTIES_AGENT_ARGS_KEY = "properties";
    private static final String ENVIRONMENT_AGENT_ARGS_KEY = "environment";
    private static final String SERVER_PORT_AGENT_ARGS_KEY = "serverPort";
    private static final String ID_AGENT_ARGS_KEY = "id";
    private final Map<String, String> environment;
    private final Map<String, String> systemProperties;
    private Number serverPort;
    private String id;

    public AgentArguments(Map<String, String> environment, Map<String, String> systemProperties) {
        this.environment = environment;
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Number getServerPort() {
        return this.serverPort;
    }

    public String getId() {
        return this.id;
    }

    public void setAppName(String appName) {
        this.environment.put(NEW_RELIC_APP_NAME_ENV_VARIABLE, appName);
    }

    public void setCommandLine(String commandLine) {
        this.environment.put(NEW_RELIC_COMMAND_LINE_ENV_VARIABLE, commandLine);
    }

    public AgentArguments update(String appName, String commandLine, Integer serverPort, String pid) {
        AgentArguments args = new AgentArguments(new HashMap<String, String>(this.environment), new HashMap<String, String>(this.systemProperties));
        if (appName != null) {
            args.setAppName(appName);
        }
        if (commandLine != null) {
            args.setCommandLine(commandLine);
        }
        args.serverPort = serverPort;
        args.id = pid;
        return args;
    }

    public static AgentArguments fromJsonObject(Object object) {
        Map map = (Map)object;
        AgentArguments args = new AgentArguments((Map)map.get(ENVIRONMENT_AGENT_ARGS_KEY), (Map)map.get(SYSTEM_PROPERTIES_AGENT_ARGS_KEY));
        args.serverPort = (Number)map.get(SERVER_PORT_AGENT_ARGS_KEY);
        args.id = (String)map.get(ID_AGENT_ARGS_KEY);
        return args;
    }

    @Override
    public String toJSONString() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ENVIRONMENT_AGENT_ARGS_KEY, this.environment);
        args.put(SYSTEM_PROPERTIES_AGENT_ARGS_KEY, this.systemProperties);
        args.put(ID_AGENT_ARGS_KEY, this.id);
        if (this.serverPort != null) {
            args.put(SERVER_PORT_AGENT_ARGS_KEY, this.serverPort);
        }
        return JSONObject.toJSONString(args);
    }
}

