/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.util.StackTraces;
import java.lang.management.ThreadInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DeadlockTraceError
extends TracedError {
    private final String message;
    private final String exceptionClass;
    private final Map<String, StackTraceElement[]> stackTraces;

    private DeadlockTraceError(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, long timestampInMillis, String message, String exceptionClass, Map<String, StackTraceElement[]> stackTraces, Map<String, ?> errorAttributes) {
        super(errorCollectorConfig, appName, frontendMetricName, timestampInMillis, "", null, null, null, errorAttributes, null, null, false, null);
        this.stackTraces = stackTraces;
        this.message = message;
        this.exceptionClass = exceptionClass;
    }

    public static DeadlockTraceErrorRequired builder(ErrorCollectorConfig errorCollectorConfig, String appName, long timestampInMillis) {
        return new Builder(errorCollectorConfig, appName, timestampInMillis);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getExceptionClass() {
        return this.exceptionClass;
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public boolean incrementsErrorMetric() {
        return false;
    }

    @Override
    public Map<String, Collection<String>> stackTraces() {
        HashMap<String, Collection<String>> traces = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, StackTraceElement[]> entry : this.stackTraces.entrySet()) {
            traces.put(entry.getKey(), StackTraces.stackTracesToStrings(entry.getValue()));
        }
        return traces;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stackTraces == null ? 0 : this.stackTraces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeadlockTraceError other = (DeadlockTraceError)obj;
        return !(this.stackTraces == null ? other.stackTraces != null : !this.stackTraces.equals(other.stackTraces));
    }

    public static interface DeadlockTraceErrorRequired {
        public Builder threadInfoAndStackTrace(ThreadInfo var1, Map<String, StackTraceElement[]> var2);
    }

    public static class Builder
    extends TracedError.Builder
    implements DeadlockTraceErrorRequired {
        private String message;
        private String exceptionClass;
        private Map<String, StackTraceElement[]> stackTraces;

        Builder(ErrorCollectorConfig errorCollectorConfig, String appName, long timestampInMillis) {
            super(errorCollectorConfig, appName, "Unknown", timestampInMillis);
        }

        @Override
        public Builder threadInfoAndStackTrace(ThreadInfo thread, Map<String, StackTraceElement[]> stackTraces) {
            this.message = "Deadlocked thread: " + thread.getThreadName();
            this.exceptionClass = "Deadlock";
            this.stackTraces = stackTraces;
            return this;
        }

        @Override
        public DeadlockTraceError build() {
            return new DeadlockTraceError(this.errorCollectorConfig, this.appName, this.frontendMetricName, this.timestampInMillis, this.message, this.exceptionClass, this.stackTraces, this.errorAttributes);
        }
    }
}

