/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.SecurityAgentConfig;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.weaver.AgentWeaverListener;
import com.newrelic.agent.instrumentation.weaver.WeaveViolationLogger;
import com.newrelic.agent.instrumentation.weaver.errorhandler.LogAndReturnOriginal;
import com.newrelic.agent.instrumentation.weaver.extension.CaffeineBackedExtensionClass;
import com.newrelic.agent.instrumentation.weaver.extension.ExtensionHolderFactoryImpl;
import com.newrelic.agent.instrumentation.weaver.preprocessors.AgentPostprocessors;
import com.newrelic.agent.instrumentation.weaver.preprocessors.AgentPreprocessors;
import com.newrelic.agent.instrumentation.weaver.preprocessors.TracedWeaveInstrumentationTracker;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.api.agent.weaver.WeaveIntoAllMethods;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;
import com.newrelic.bootstrap.BootstrapAgent;
import com.newrelic.bootstrap.EmbeddedJarFilesImpl;
import com.newrelic.weave.ClassWeave;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.CachedWeavePackage;
import com.newrelic.weave.weavepackage.ClassWeavedListener;
import com.newrelic.weave.weavepackage.ExtensionClassTemplate;
import com.newrelic.weave.weavepackage.NewClassAppender;
import com.newrelic.weave.weavepackage.PackageWeaveResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import com.newrelic.weave.weavepackage.WeavePackageManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ClassWeaverService
implements ClassMatchVisitorFactory,
ContextClassTransformer {
    private static final int PARTITIONS = 8;
    private static ClassNode EXTENSION_TEMPLATE;
    private final ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> tracedWeaveInstrumentationDetails = new ConcurrentHashMap<String, Set<TracedWeaveInstrumentationTracker>>();
    private final WeaveViolationLogger weaveViolationLogger;
    private final AgentWeaverListener listener;
    private final WeavePackageManager weavePackageManager;
    private final Set<String> internalWeavePackages = Sets.newConcurrentHashSet();
    private final Map<String, String> externalWeavePackages = new ConcurrentHashMap<String, String>();
    private final Instrumentation instrumentation;
    private final ConcurrentMap<ClassLoader, ClassCache> retransformCaches = new ConcurrentHashMap<ClassLoader, ClassCache>();
    private volatile boolean isRetransforming = false;

    public ClassWeaverService(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.weaveViolationLogger = new WeaveViolationLogger(Agent.LOG);
        this.listener = new AgentWeaverListener(this.weaveViolationLogger);
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        ClassTransformerConfig config = agentConfig.getClassTransformerConfig();
        this.weavePackageManager = new WeavePackageManager(this.listener, instrumentation, config.getMaxPreValidatedClassLoaders(), config.preValidateWeavePackages(), config.preMatchWeaveMethods());
    }

    public void registerInstrumentation() {
        this.loadInternalWeavePackages();
        this.loadExternalWeavePackages(ServiceFactory.getExtensionService().getWeaveExtensions());
    }

    public void registerSecurityInstrumentation() {
        if (SecurityAgentConfig.shouldInitializeSecurityAgent()) {
            this.loadInternalSecurityWeavePackages();
        }
    }

    public Runnable createRetransformRunnable(Class<?>[] loadedClasses) {
        return new RetransformRunnable(loadedClasses);
    }

    private WeavePackage createWeavePackage(InputStream inputStream, String source) throws Exception {
        Boolean jcacheDatastoreEnabled;
        JarInputStream jarStream = new JarInputStream(inputStream);
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        WeavePackageConfig weavePackageConfig = this.createWeavePackageConfig(jarStream, source, this.instrumentation, WeavePackageType.INTERNAL, agentConfig);
        ClassTransformerConfig classTransformerConfig = agentConfig.getClassTransformerConfig();
        String weavePackageName = weavePackageConfig.getName();
        if (!classTransformerConfig.isWeavePackageEnabled(weavePackageConfig)) {
            if (weavePackageConfig.isEnabled()) {
                Agent.LOG.log(Level.INFO, "Instrumentation {0} is disabled. Skipping.", weavePackageName);
            }
            return null;
        }
        if ("com.newrelic.instrumentation.jcache-1.0.0".equals(weavePackageName) && (jcacheDatastoreEnabled = (Boolean)agentConfig.getValue("class_transformer.com.newrelic.instrumentation.jcache-datastore-1.0.0.enabled", Boolean.FALSE)).booleanValue()) {
            Agent.LOG.log(Level.INFO, " Instrumentation {0} is disabled since {1} is enabled. Skipping.", weavePackageName, "com.newrelic.instrumentation.jcache-datastore-1.0.0");
            return null;
        }
        WeavePackage weavePackage = CachedWeavePackage.createWeavePackage(new URL(source), jarStream, weavePackageConfig);
        return weavePackage;
    }

    private WeavePackageConfig createWeavePackageConfig(JarInputStream jarStream, String source, Instrumentation instrumentation, WeavePackageType type, AgentConfig agentConfig) throws Exception {
        AgentPreprocessors preprocessors = new AgentPreprocessors(agentConfig, this.tracedWeaveInstrumentationDetails);
        AgentPostprocessors postprocessors = new AgentPostprocessors();
        WeavePackageConfig result = WeavePackageConfig.builder().source(source).jarInputStream(jarStream).weavePreprocessor(preprocessors).weavePostprocessor(postprocessors).errorHandleClassNode(LogAndReturnOriginal.ERROR_HANDLER_NODE).extensionClassTemplate(EXTENSION_TEMPLATE).build();
        preprocessors.setInstrumentationTitle(result.getName());
        if (result.getVendorId() != null) {
            type = WeavePackageType.FIELD;
        }
        postprocessors.setWeavePackageType(type);
        return result;
    }

    private void loadInternalSecurityWeavePackages() {
        URL securityAgentUrl;
        Agent.LOG.log(Level.FINE, "Starting security instrumentation load");
        try {
            securityAgentUrl = EmbeddedJarFilesImpl.INSTANCE.getJarFileInAgent("newrelic-security-agent").toURI().toURL();
        }
        catch (Exception err) {
            Agent.LOG.log(Level.SEVERE, "Error while loading security instrumentation packages. Security agent jar was not found due to error : {0}", err.getMessage());
            Agent.LOG.log(Level.FINE, "Error while loading security instrumentation packages. Security agent jar was not found due to error : {0}", err);
            return;
        }
        Collection<String> jarFileNames = AgentJarHelper.findJarFileNames(securityAgentUrl, Pattern.compile("instrumentation-security\\/(.*).jar"));
        if (jarFileNames.isEmpty()) {
            Agent.LOG.log(Level.SEVERE, "No security instrumentation packages were found in the agent.");
        } else {
            Agent.LOG.log(Level.FINE, "Loading {0} security instrumentation packages", jarFileNames.size());
        }
        int partitions = Math.min(jarFileNames.size(), 8);
        CountDownLatch executorCountDown = new CountDownLatch(partitions);
        List<Set<String>> weavePackagePartitions = this.partitionInstrumentationJars(jarFileNames, partitions);
        for (Set<String> weavePackageJars : weavePackagePartitions) {
            Runnable loadWeavePackagesRunnable = () -> {
                try {
                    for (String name : weavePackageJars) {
                        URL instrumentationUrl = new URL("jar:" + securityAgentUrl.toExternalForm() + "!/" + name);
                        this.registerInstrumentation(instrumentationUrl);
                    }
                }
                catch (Throwable t2) {
                    Agent.LOG.log(Level.FINER, t2, "A thread loading weaved packages threw an error");
                }
                finally {
                    executorCountDown.countDown();
                }
            };
            new Thread(loadWeavePackagesRunnable).start();
        }
        try {
            executorCountDown.await();
            Agent.LOG.log(Level.FINE, "Loaded {0} internal instrumentation packages", this.internalWeavePackages.size());
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINE, e, "Interrupted while waiting for instrumentation packages.");
        }
    }

    public void registerInstrumentationCloseable(String instrumentationName, Closeable closeable) {
        WeavePackage weavePackage = this.weavePackageManager.getWeavePackage(instrumentationName);
        this.listener.registerInstrumentationCloseable(instrumentationName, weavePackage, closeable);
    }

    private void loadInternalWeavePackages() {
        Collection<String> jarFileNames = AgentJarHelper.findAgentJarFileNames(Pattern.compile("instrumentation\\/(.*).jar"));
        if (jarFileNames.isEmpty()) {
            Agent.LOG.log(Level.SEVERE, "No instrumentation packages were found in the agent.");
        } else {
            Agent.LOG.log(Level.FINE, "Loading {0} instrumentation packages", jarFileNames.size());
        }
        int partitions = Math.min(jarFileNames.size(), 8);
        CountDownLatch executorCountDown = new CountDownLatch(partitions);
        List<Set<String>> weavePackagePartitions = this.partitionInstrumentationJars(jarFileNames, partitions);
        for (Set<String> weavePackageJars : weavePackagePartitions) {
            Runnable loadWeavePackagesRunnable = () -> {
                try {
                    for (String name : weavePackageJars) {
                        URL instrumentationUrl = BootstrapAgent.class.getResource('/' + name);
                        if (instrumentationUrl == null) {
                            Agent.LOG.error("Unable to find instrumentation jar: " + name);
                            continue;
                        }
                        this.registerInstrumentation(instrumentationUrl);
                    }
                }
                catch (Throwable t2) {
                    Agent.LOG.log(Level.FINER, t2, "A thread loading weaved packages threw an error");
                }
                finally {
                    executorCountDown.countDown();
                }
            };
            new Thread(loadWeavePackagesRunnable).start();
        }
        try {
            executorCountDown.await();
            Agent.LOG.log(Level.FINE, "Loaded {0} internal instrumentation packages", this.internalWeavePackages.size());
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINE, e, "Interrupted while waiting for instrumentation packages.");
        }
    }

    private void registerInstrumentation(URL instrumentationUrl) {
        try (InputStream inputStream = instrumentationUrl.openStream();){
            WeavePackage internalWeavePackage = this.createWeavePackage(inputStream, instrumentationUrl.toExternalForm());
            if (null == internalWeavePackage) {
                Agent.LOG.log(Level.FINEST, "internal weave package: {0} was null", instrumentationUrl.toExternalForm());
            } else if (internalWeavePackage.getPackageViolations().size() > 0) {
                Agent.LOG.log(Level.FINER, "skip loading weave package: {0}", internalWeavePackage.getName());
                for (WeaveViolation violation : internalWeavePackage.getPackageViolations()) {
                    Agent.LOG.log(Level.FINER, "\t violation: {0}", violation);
                }
            } else {
                Agent.LOG.log(Level.FINER, "adding weave package: {0}", internalWeavePackage.getName());
                this.internalWeavePackages.add(internalWeavePackage.getName());
                this.weavePackageManager.register(internalWeavePackage);
            }
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINER, t2, "unable to load weave package jar {0}", instrumentationUrl);
        }
    }

    private List<Set<String>> partitionInstrumentationJars(Collection<String> jarFileNames, int partitions) {
        ArrayList<Set<String>> instrumentationPartitions = new ArrayList<Set<String>>(partitions);
        for (int i = 0; i < partitions; ++i) {
            instrumentationPartitions.add(new HashSet());
        }
        int index = 0;
        for (String jarFileName : jarFileNames) {
            ((Set)instrumentationPartitions.get(index++ % partitions)).add(jarFileName);
        }
        return instrumentationPartitions;
    }

    private Collection<ClassMatchVisitorFactory> loadExternalWeavePackages(Collection<File> weaveExtensions) {
        HashSet<ClassMatchVisitorFactory> matchers = new HashSet<ClassMatchVisitorFactory>();
        for (File weaveExtension : weaveExtensions) {
            try {
                JarInputStream stream = new JarInputStream(new FileInputStream(weaveExtension));
                Throwable throwable = null;
                try {
                    AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
                    WeavePackageConfig weaveConfig = this.createWeavePackageConfig(stream, weaveExtension.getAbsolutePath(), this.instrumentation, WeavePackageType.CUSTOM, agentConfig);
                    ClassTransformerConfig classTransformerConfig = agentConfig.getClassTransformerConfig();
                    String instrName = weaveConfig.getName();
                    if (this.weavePackageManager.isRegistered(instrName)) {
                        this.weavePackageManager.deregister(instrName);
                        this.externalWeavePackages.remove(weaveExtension.getAbsolutePath());
                    }
                    if (!classTransformerConfig.isWeavePackageEnabled(weaveConfig)) {
                        if (!weaveConfig.isEnabled()) continue;
                        Agent.LOG.log(Level.INFO, "Instrumentation {0} is disabled. Skipping.", instrName);
                        continue;
                    }
                    WeavePackage externalPackage = WeavePackage.createWeavePackage(stream, weaveConfig);
                    if (externalPackage.getPackageViolations().size() > 0) {
                        Agent.LOG.log(Level.FINER, "skip loading external weave package: {0}", instrName);
                        for (WeaveViolation violation : externalPackage.getPackageViolations()) {
                            Agent.LOG.log(Level.FINER, "\t{0}", violation);
                        }
                        continue;
                    }
                    this.weavePackageManager.register(externalPackage);
                    this.externalWeavePackages.put(weaveExtension.getAbsolutePath(), weaveConfig.getName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, e, "Error reading weave extension {0}", weaveExtension.getAbsolutePath());
            }
        }
        return matchers;
    }

    private Collection<ClassMatchVisitorFactory> unloadExternalWeavePackages(Set<String> removedFilePaths) {
        Agent.LOG.log(Level.INFO, "ClassWeaveService removing {0} weave packages.", removedFilePaths.size());
        HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSetWithExpectedSize(removedFilePaths.size());
        for (String removedFilePath : removedFilePaths) {
            String weavePackageName = this.externalWeavePackages.get(removedFilePath);
            if (this.internalWeavePackages.contains(weavePackageName)) {
                Agent.LOG.log(Level.FINER, "Attempted to unload internal weave package {0} -- {1}. Ignoring request.", weavePackageName, removedFilePath);
                continue;
            }
            WeavePackage externalPackage = this.weavePackageManager.deregister(weavePackageName);
            if (null == externalPackage) {
                Agent.LOG.log(Level.FINER, "Attempted to unload non-existent weave package {0} -- {1}. Ignoring request.", weavePackageName, removedFilePath);
                continue;
            }
            this.externalWeavePackages.remove(removedFilePath);
        }
        return matchers;
    }

    public Runnable reloadExternalWeavePackages(Collection<File> newWeaveExtensions, Collection<File> removedWeaveExtensions) {
        this.loadExternalWeavePackages(newWeaveExtensions);
        HashSet<String> removedFilePaths = Sets.newHashSetWithExpectedSize(removedWeaveExtensions.size());
        for (File removedFile : removedWeaveExtensions) {
            removedFilePaths.add(removedFile.getAbsolutePath());
        }
        this.unloadExternalWeavePackages(removedFilePaths);
        Class[] loadedClasses = this.instrumentation.getAllLoadedClasses();
        return this.createRetransformRunnable(loadedClasses);
    }

    private ClassCache getClassCache(ClassLoader loader) {
        ClassCache cache;
        if (null == loader) {
            loader = BootstrapLoader.PLACEHOLDER;
        }
        if (this.isRetransforming) {
            if (!this.retransformCaches.containsKey(loader)) {
                if (loader == BootstrapLoader.PLACEHOLDER) {
                    this.retransformCaches.putIfAbsent(loader, new ClassCache(BootstrapLoader.get()));
                } else {
                    this.retransformCaches.putIfAbsent(loader, new ClassCache(new ClassLoaderFinder(loader)));
                }
            }
            if (null == (cache = (ClassCache)this.retransformCaches.get(loader))) {
                cache = new ClassCache(new ClassLoaderFinder(loader));
            }
        } else {
            cache = loader == BootstrapLoader.PLACEHOLDER ? new ClassCache(BootstrapLoader.get()) : new ClassCache(new ClassLoaderFinder(loader));
        }
        return cache;
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
        if (this.isRetransforming) {
            try {
                if (this.weavePackageManager.match(loader, reader.getClassName(), this.getClassCache(loader)).size() == 0) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        context.putMatch(this, null);
        return null;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, final InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        if (!PointCutClassTransformer.isValidClassName(className)) {
            return null;
        }
        ClassWeavedListener classWeavedCallback = new ClassWeavedListener(){

            @Override
            public void classWeaved(PackageWeaveResult weaveResult, ClassLoader classloader, ClassCache cache) {
                List<WeaveViolation> violations = weaveResult.getValidationResult().getViolations();
                if (!violations.isEmpty()) {
                    ClassWeaverService.this.weaveViolationLogger.logWeaveViolations(weaveResult.getValidationResult(), classloader, false);
                    return;
                }
                String packageName = weaveResult.getValidationResult().getWeavePackage().getName();
                if (Agent.LOG.isFinerEnabled()) {
                    try {
                        if (Agent.LOG.isFinerEnabled()) {
                            ClassInformation weavedClass = cache.getClassInformation(weaveResult.getClassName());
                            Agent.LOG.log(Level.FINER, "{0} matched {1}", packageName, weavedClass.className);
                            for (String superName : weavedClass.getAllSuperNames(cache)) {
                                Agent.LOG.log(Level.FINER, "\ts: {0}", superName);
                            }
                            for (String interfaceName : weavedClass.getAllInterfaces(cache)) {
                                Agent.LOG.log(Level.FINER, "\ti: {0}", interfaceName);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        Agent.LOG.log(Level.FINEST, ioe, "exception while getting supertype info");
                    }
                }
                if (weaveResult.weavedClass()) {
                    try {
                        Map<String, byte[]> annotationProxyClasses = weaveResult.getAnnotationProxyClasses();
                        if (!annotationProxyClasses.isEmpty()) {
                            if (BootstrapLoader.PLACEHOLDER == classloader) {
                                NewClassAppender.appendClassesToBootstrapClassLoader(ClassWeaverService.this.instrumentation, annotationProxyClasses);
                            } else {
                                NewClassAppender.appendClasses(classloader, annotationProxyClasses);
                            }
                        }
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINE, e, "Unable to add annotation proxy classes");
                    }
                    String weaveClassStat = MessageFormat.format("Supportability/WeaveInstrumentation/WeaveClass/{0}/{1}", packageName, weaveResult.getClassName());
                    ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(weaveClassStat, 1.0f), weaveClassStat);
                    for (String originalName : weaveResult.getWeavedMethods().keySet()) {
                        Agent.LOG.log(Level.FINE, "{0}: weaved target {1}-{2}", packageName, classloader, weaveResult.getClassName());
                        for (Method method : weaveResult.getWeavedMethods().get(originalName)) {
                            Agent.LOG.log(Level.FINE, "\t{0}.{1}:{2}", originalName, method.getName(), method.getDescriptor());
                            context.addWeavedMethod(method, packageName);
                        }
                        ClassWeaverService.addTraceInformation(ClassWeaverService.this.tracedWeaveInstrumentationDetails, packageName, context, weaveResult.getComposite(), originalName);
                    }
                } else {
                    Agent.LOG.log(Level.FINER, "{0} matched class {1} but no methods were weaved.", packageName, weaveResult.getClassName());
                }
            }
        };
        try {
            return this.weavePackageManager.weave(loader, this.getClassCache(loader), className, classfileBuffer, context.getSkipMethods(), classWeavedCallback);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void addTraceInformation(ConcurrentMap<String, Set<TracedWeaveInstrumentationTracker>> weaveTraceDetailsTrackers, String weavePackageName, InstrumentationContext context, ClassNode composite, String originalClassName) {
        Set traceDetailsTrackers = (Set)weaveTraceDetailsTrackers.get(weavePackageName);
        if (null != traceDetailsTrackers) {
            for (TracedWeaveInstrumentationTracker traceDetails : traceDetailsTrackers) {
                if (!weavePackageName.equals(traceDetails.getWeavePackageName()) || !originalClassName.equals(traceDetails.getClassName())) continue;
                List<MethodNode> compositeMethods = ClassWeaverService.getMatches(composite, traceDetails);
                for (MethodNode compositeMethod : compositeMethods) {
                    Method bridgeTarget;
                    MethodNode bridgeTargetNode;
                    if ((compositeMethod.access & 0x40) != 0 && null != (bridgeTargetNode = WeaveUtils.findMatch(composite.methods, bridgeTarget = ClassWeave.whereDoesTheBridgeGo(compositeMethod)))) {
                        compositeMethod = bridgeTargetNode;
                    }
                    Agent.LOG.log(Level.FINER, "Writing TracedWeaveInstrumentation: {0} - {1}.{2}({3})", weavePackageName, composite.name, compositeMethod.name, compositeMethod.desc);
                    traceDetails.addToInstrumentationContext(context, new Method(compositeMethod.name, compositeMethod.desc));
                    TracedWeaveInstrumentationTracker.removeTraceAnnotations(compositeMethod);
                }
            }
        }
    }

    private static List<MethodNode> getMatches(ClassNode composite, TracedWeaveInstrumentationTracker traceDetails) {
        ArrayList<MethodNode> matches = new ArrayList<MethodNode>();
        if (traceDetails.isWeaveIntoAllMethods()) {
            for (MethodNode method : composite.methods) {
                List<AnnotationNode> methodAnnotations = WeaveUtils.getMethodAnnotations(method);
                for (AnnotationNode methodAnnotation : methodAnnotations) {
                    if (!Type.getType(WeaveIntoAllMethods.class).getDescriptor().equals(methodAnnotation.desc)) continue;
                    matches.add(method);
                }
            }
        } else {
            MethodNode match = WeaveUtils.findMatch(composite.methods, traceDetails.getMethod());
            if (match != null) {
                matches.add(match);
            }
        }
        return matches;
    }

    public WeavePackageManager getWeavePackageManger() {
        return this.weavePackageManager;
    }

    static {
        AgentBridge.extensionHolderFactory = new ExtensionHolderFactoryImpl();
        try {
            EXTENSION_TEMPLATE = WeaveUtils.convertToClassNode(WeaveUtils.getClassBytesFromClassLoaderResource(CaffeineBackedExtensionClass.class.getName(), CaffeineBackedExtensionClass.class.getClassLoader()));
        }
        catch (Exception e) {
            AgentBridge.getAgent().getLogger().log(Level.WARNING, (Throwable)e, "Unable to initialize custom extension class template. Falling back to default java NewField implementation");
            EXTENSION_TEMPLATE = ExtensionClassTemplate.DEFAULT_EXTENSION_TEMPLATE;
        }
    }

    private class RetransformRunnable
    implements Runnable {
        private final Class[] loadedClasses;

        public RetransformRunnable(Class[] loadedClasses) {
            this.loadedClasses = loadedClasses;
        }

        @Override
        public void run() {
            try {
                ClassWeaverService.this.isRetransforming = true;
                ServiceFactory.getClassTransformerService().retransformMatchingClassesImmediately(this.loadedClasses, Sets.newHashSet(ClassWeaverService.this));
            }
            finally {
                ClassWeaverService.this.isRetransforming = false;
                ClassWeaverService.this.retransformCaches.clear();
            }
        }
    }
}

