/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.preprocessors;

import com.newrelic.agent.bridge.reflect.ClassReflection;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import java.util.HashMap;
import java.util.Map;

class ReflectionHelper {
    private static final ReflectionHelper INSTANCE = new ReflectionHelper();
    private final Map<String, ClassReflector> classes = new HashMap<String, ClassReflector>();

    public ReflectionHelper() {
        for (java.lang.reflect.Method m4 : ClassReflection.class.getMethods()) {
            Method staticMethod = Method.getMethod(m4);
            if (!m4.getDeclaringClass().equals(ClassReflection.class) || staticMethod.getArgumentTypes().length <= 0) continue;
            Type targetClass = staticMethod.getArgumentTypes()[0];
            Class[] args = new Class[m4.getParameterTypes().length - 1];
            System.arraycopy(m4.getParameterTypes(), 1, args, 0, staticMethod.getArgumentTypes().length - 1);
            try {
                m4.getParameterTypes()[0].getMethod(m4.getName(), args);
                ClassReflector classReflector = this.classes.get(targetClass.getInternalName());
                if (classReflector == null) {
                    classReflector = new ClassReflector();
                    this.classes.put(targetClass.getInternalName(), classReflector);
                }
                Type[] argumentTypes = new Type[staticMethod.getArgumentTypes().length - 1];
                System.arraycopy(staticMethod.getArgumentTypes(), 1, argumentTypes, 0, staticMethod.getArgumentTypes().length - 1);
                Method targetMethod = new Method(m4.getName(), staticMethod.getReturnType(), argumentTypes);
                classReflector.methods.put(targetMethod, staticMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static ReflectionHelper get() {
        return INSTANCE;
    }

    public boolean process(String owner, String name, String desc, GeneratorAdapter generatorAdapter) {
        Method method;
        ClassReflector classReflector = this.classes.get(owner);
        if (classReflector != null && (method = (Method)classReflector.methods.get(new Method(name, desc))) != null) {
            generatorAdapter.invokeStatic(Type.getType(ClassReflection.class), method);
            return true;
        }
        return false;
    }

    private static class ClassReflector {
        private final Map<Method, Method> methods = new HashMap<Method, Method>();
    }
}

