/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.values;

import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.DataSourceJmxMetricGenerator;
import com.newrelic.agent.jmx.metrics.JmxAction;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.jmx.metrics.ServerJmxMetricGenerator;
import java.util.ArrayList;
import java.util.List;

public class TomcatJmxValues
extends JmxFrameworkValues {
    public static final String PREFIX = "Catalina";
    private static final int METRIC_COUNT = 5;
    private static final JmxMetric ACTIVE_SESSIONS = ServerJmxMetricGenerator.SESSION_ACTIVE_COUNT.createMetric("activeSessions");
    private static final JmxMetric EXPIRED_SESSIONS = ServerJmxMetricGenerator.SESSION_EXPIRED_COUNT.createMetric("expiredSessions");
    private static final JmxMetric REJECTED_SESSIONS = ServerJmxMetricGenerator.SESSION_REJECTED_COUNT.createMetric("rejectedSessions");
    private static final JmxMetric SESSION_ALIVE_TIME = ServerJmxMetricGenerator.SESSION_AVG_ALIVE_TIME.createMetric("sessionAverageAliveTime");
    private static final JmxMetric CONNECTIONS_ACTIVE = DataSourceJmxMetricGenerator.CONNECTIONS_ACTIVE.createMetric("numActive");
    private static final JmxMetric CONNECTIONS_IDLE = DataSourceJmxMetricGenerator.CONNECTIONS_IDLE.createMetric("numIdle");
    private static final JmxMetric CONNECTIONS_MAX = DataSourceJmxMetricGenerator.CONNECTIONS_MAX.createMetric("maxActive");
    private static final JmxMetric CONNECTIONS_MAX_TOMCAT_8 = DataSourceJmxMetricGenerator.CONNECTIONS_MAX.createMetric("maxTotal");
    private static final JmxMetric CURRENT_MAX_COUNT = ServerJmxMetricGenerator.MAX_THREAD_POOL_COUNT.createMetric("maxThreads");
    private static final JmxMetric CURRENT_ACTIVE_COUNT = ServerJmxMetricGenerator.ACTIVE_THREAD_POOL_COUNT.createMetric("currentThreadsBusy");
    private static final JmxMetric CURRENT_IDLE_COUNT = JmxMetric.create(new String[]{"currentThreadCount", "currentThreadsBusy"}, "Idle", JmxAction.SUBTRACT_ALL_FROM_FIRST, JmxType.SIMPLE);
    private final List<BaseJmxValue> metrics = new ArrayList<BaseJmxValue>(5);

    public TomcatJmxValues() {
        this.createMetrics("*");
    }

    public TomcatJmxValues(String name) {
        this.createMetrics(name);
    }

    private void createMetrics(String name) {
        this.metrics.add(new BaseJmxValue(name + ":type=Manager,context=*,host=*,*", "JmxBuiltIn/Session/{context}/", new JmxMetric[]{ACTIVE_SESSIONS, EXPIRED_SESSIONS, REJECTED_SESSIONS, SESSION_ALIVE_TIME}));
        this.metrics.add(new BaseJmxValue(name + ":type=Manager,path=*,host=*", "JmxBuiltIn/Session/{path}/", new JmxMetric[]{ACTIVE_SESSIONS, EXPIRED_SESSIONS, REJECTED_SESSIONS, SESSION_ALIVE_TIME}));
        this.metrics.add(new BaseJmxValue(name + ":type=ThreadPool,name=*", "JmxBuiltIn/ThreadPool/{name}/", new JmxMetric[]{CURRENT_ACTIVE_COUNT, CURRENT_IDLE_COUNT, CURRENT_MAX_COUNT}));
        this.metrics.add(new BaseJmxValue(name + ":type=DataSource,context=*,host=*,class=javax.sql.DataSource,name=*", "JmxBuiltIn/DataSources/{name}/", new JmxMetric[]{CONNECTIONS_ACTIVE, CONNECTIONS_IDLE, CONNECTIONS_MAX, CONNECTIONS_MAX_TOMCAT_8}));
        this.metrics.add(new BaseJmxValue(name + ":type=DataSource,class=javax.sql.DataSource,name=*", "JmxBuiltIn/DataSources/{name}/", new JmxMetric[]{CONNECTIONS_ACTIVE, CONNECTIONS_IDLE, CONNECTIONS_MAX, CONNECTIONS_MAX_TOMCAT_8}));
    }

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return this.metrics;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

