/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.superagent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.superagent.AgentHealth;
import com.newrelic.agent.superagent.HealthDataChangeListener;
import com.newrelic.agent.superagent.HealthDataProducer;
import com.newrelic.agent.superagent.SuperAgentIntegrationHealthClient;
import com.newrelic.agent.superagent.SuperAgentIntegrationUtils;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.api.agent.NewRelic;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SuperAgentIntegrationService
extends AbstractService
implements HealthDataChangeListener {
    private final AgentConfig agentConfig;
    private final SuperAgentIntegrationHealthClient client;
    private final AgentHealth agentHealth;
    private ScheduledExecutorService scheduler;

    public SuperAgentIntegrationService(SuperAgentIntegrationHealthClient client, AgentConfig agentConfig, HealthDataProducer ... healthProducers) {
        super(SuperAgentIntegrationService.class.getSimpleName());
        this.agentConfig = agentConfig;
        this.client = client;
        this.agentHealth = new AgentHealth(SuperAgentIntegrationUtils.getPseudoCurrentTimeNanos());
        for (HealthDataProducer healthProducer : healthProducers) {
            healthProducer.registerHealthDataChangeListener(this);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled()) {
            Agent.LOG.log(Level.INFO, "SuperAgentIntegrationService starting: Health file location: {0}  Frequency: {1}  Scheme: {2}", this.agentConfig.getSuperAgentIntegrationConfig().getHealthDeliveryLocation(), this.agentConfig.getSuperAgentIntegrationConfig().getHealthReportingFrequency(), this.agentConfig.getSuperAgentIntegrationConfig().getHealthClientType());
            NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/SuperAgent/Health/enabled");
            int messageSendFrequency = this.agentConfig.getSuperAgentIntegrationConfig().getHealthReportingFrequency();
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("New Relic Super Agent Integration Service", true));
            this.scheduler.scheduleWithFixedDelay(() -> this.client.sendHealthMessage(this.agentHealth), messageSendFrequency, messageSendFrequency, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isEnabled()) {
            this.scheduler.shutdown();
            this.agentHealth.setUnhealthyStatus(AgentHealth.Status.SHUTDOWN, new String[0]);
            this.client.sendHealthMessage(this.agentHealth);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.agentConfig.getSuperAgentIntegrationConfig().isEnabled() && this.client != null && this.client.isValid();
    }

    @Override
    public void onUnhealthyStatus(AgentHealth.Status newStatus, String ... additionalInfo) {
        if (this.isEnabled()) {
            this.agentHealth.setUnhealthyStatus(newStatus, additionalInfo);
        }
    }

    @Override
    public void onHealthyStatus(AgentHealth.Category ... categories) {
        if (this.isEnabled()) {
            for (AgentHealth.Category category : categories) {
                this.agentHealth.setHealthyStatus(category);
            }
        }
    }
}

