/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.superagent;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.SuperAgentIntegrationConfig;
import com.newrelic.agent.superagent.AgentHealth;
import com.newrelic.agent.superagent.HealthDataChangeListener;
import com.newrelic.agent.superagent.SuperAgentIntegrationClientFactory;
import com.newrelic.agent.superagent.SuperAgentIntegrationHealthClient;
import java.util.List;

public class SuperAgentIntegrationUtils {
    public static long getPseudoCurrentTimeNanos() {
        return System.currentTimeMillis() * 1000000L;
    }

    public static void reportUnhealthyStatus(List<HealthDataChangeListener> healthDataChangeListeners, AgentHealth.Status newStatus, String ... additionalInfo) {
        for (HealthDataChangeListener listener : healthDataChangeListeners) {
            listener.onUnhealthyStatus(newStatus, additionalInfo);
        }
    }

    public static void reportHealthyStatus(List<HealthDataChangeListener> healthDataChangeListeners, AgentHealth.Category ... categories) {
        for (HealthDataChangeListener listener : healthDataChangeListeners) {
            listener.onHealthyStatus(categories);
        }
    }

    public static void reportUnhealthyStatusPriorToServiceStart(AgentConfig config, AgentHealth.Status status) {
        SuperAgentIntegrationConfig superAgentIntegrationConfig = config.getSuperAgentIntegrationConfig();
        if (superAgentIntegrationConfig.isEnabled()) {
            SuperAgentIntegrationHealthClient client = SuperAgentIntegrationClientFactory.createHealthClient(superAgentIntegrationConfig);
            AgentHealth agentHealth = new AgentHealth(SuperAgentIntegrationUtils.getPseudoCurrentTimeNanos());
            agentHealth.setUnhealthyStatus(status, new String[0]);
            client.sendHealthMessage(agentHealth);
        }
    }
}

