/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.app;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.DaemonConfig;
import com.newrelic.jfr.daemon.EventConverter;
import com.newrelic.jfr.daemon.JFRUploader;
import com.newrelic.jfr.daemon.JfrController;
import com.newrelic.jfr.daemon.SetupUtils;
import com.newrelic.jfr.daemon.app.JmxJfrRecorderFactory;
import com.newrelic.jfr.daemon.app.MBeanConnectionFactory;
import com.newrelic.jfr.daemon.app.RemoteEntityBridge;
import com.newrelic.telemetry.Attributes;
import java.util.Optional;
import javax.management.MBeanServerConnection;

public class JFRDaemon {
    private static final Logger logger = LoggerFactory.getLogger(JFRDaemon.class);

    public static void main(String[] args) {
        DaemonConfig config = SetupUtils.buildConfig();
        MBeanConnectionFactory connectionFactory = new MBeanConnectionFactory(config.getJmxHost(), config.getJmxPort());
        Attributes commonAttrs = SetupUtils.buildCommonAttributes(config);
        JFRUploader uploader = SetupUtils.buildUploader(config);
        JmxJfrRecorderFactory recorderFactory = new JmxJfrRecorderFactory(config, connectionFactory);
        JfrController controller = new JfrController(recorderFactory, uploader, config.getHarvestInterval());
        try {
            MBeanServerConnection connection = connectionFactory.awaitConnection(MBeanConnectionFactory.waitForeverBackoff());
            RemoteEntityBridge remoteEntityBridge = new RemoteEntityBridge();
            remoteEntityBridge.fetchRemoteEntityIdAsync(connection).thenAccept(optGuid -> {
                optGuid.ifPresent(s2 -> commonAttrs.put("entity.guid", (String)s2));
                Optional<String> remoteAppNameOptional = remoteEntityBridge.getRemoteEntityName(connection);
                if (remoteAppNameOptional.isPresent()) {
                    String remoteAppName = remoteAppNameOptional.get();
                    commonAttrs.put("service.name", remoteAppName);
                    commonAttrs.put("app.name", remoteAppName);
                }
                uploader.readyToSend(new EventConverter(commonAttrs, config.getThreadNamePattern()));
            });
            controller.loop();
        }
        catch (Throwable e) {
            logger.error("JFR Daemon is crashing!", e);
            controller.shutdown();
            throw new RuntimeException(e);
        }
    }
}

