/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.opentelemetry.export.NewRelicMetricExporter;
import com.newrelic.telemetry.opentelemetry.export.NewRelicSpanExporter;
import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;

public class NewRelicExporters {
    private static IntervalMetricReader intervalMetricReader;

    public static void start(String apiKey, String serviceName) {
        NewRelicExporters.start(new Configuration(apiKey, serviceName));
    }

    public static void start(Configuration configuration) {
        Attributes serviceNameAttributes = new Attributes().put("service.name", configuration.serviceName);
        NewRelicSpanExporter.Builder spanExporterBuilder = NewRelicSpanExporter.newBuilder().apiKey(configuration.apiKey).commonAttributes(serviceNameAttributes);
        if (configuration.enableAuditLogging) {
            spanExporterBuilder.enableAuditLogging();
        }
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)spanExporterBuilder.build()).setScheduleDelayMillis((long)(configuration.collectionIntervalSeconds * 1000)).build();
        OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor((SpanProcessor)spanProcessor);
        NewRelicMetricExporter.Builder metricExporterBuilder = NewRelicMetricExporter.newBuilder().apiKey(configuration.apiKey).commonAttributes(serviceNameAttributes);
        if (configuration.enableAuditLogging) {
            metricExporterBuilder.enableAuditLogging();
        }
        intervalMetricReader = IntervalMetricReader.builder().setExportIntervalMillis((long)(configuration.collectionIntervalSeconds * 1000)).setMetricExporter((MetricExporter)metricExporterBuilder.build()).setMetricProducers(Collections.singleton(((SdkMeterProvider)GlobalMetricsProvider.get()).getMetricProducer())).build();
    }

    public static void shutdown() {
        OpenTelemetrySdk.getGlobalTracerManagement().shutdown();
        intervalMetricReader.shutdown();
    }

    public static class Configuration {
        private final String apiKey;
        private final String serviceName;
        private boolean enableAuditLogging = false;
        private int collectionIntervalSeconds = 5;

        public Configuration(String apiKey, String serviceName) {
            if (apiKey == null || apiKey.isEmpty() || serviceName == null || serviceName.isEmpty()) {
                throw new IllegalArgumentException("apiKey and serviceName are both required parameters");
            }
            this.apiKey = apiKey;
            this.serviceName = serviceName;
        }

        public Configuration enableAuditLogging() {
            this.enableAuditLogging = true;
            return this;
        }

        public Configuration collectionIntervalSeconds(int interval) {
            this.collectionIntervalSeconds = interval;
            return this;
        }
    }
}

