/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.OkHttpPoster;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import com.newrelic.telemetry.metrics.MetricBuffer;
import com.newrelic.telemetry.opentelemetry.export.AttributeNames;
import com.newrelic.telemetry.opentelemetry.export.AttributesSupport;
import com.newrelic.telemetry.opentelemetry.export.MetricPointAdapter;
import com.newrelic.telemetry.opentelemetry.export.TimeTracker;
import com.newrelic.telemetry.opentelemetry.export.VersionFinder;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.SystemClock;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;

public class NewRelicMetricExporter
implements MetricExporter {
    private final Attributes commonAttributes;
    private final TelemetryClient telemetryClient;
    private final TimeTracker timeTracker;
    private final MetricPointAdapter metricPointAdapter;

    NewRelicMetricExporter(TelemetryClient telemetryClient, Attributes serviceAttributes, TimeTracker timeTracker, MetricPointAdapter metricPointAdapter, String serviceInstanceId) {
        this.telemetryClient = telemetryClient;
        this.timeTracker = timeTracker;
        this.commonAttributes = serviceAttributes.copy().put("instrumentation.provider", "opentelemetry").put("collector.name", "newrelic-opentelemetry-exporter").put(AttributeNames.SERVICE_INSTANCE_ID, serviceInstanceId);
        this.metricPointAdapter = metricPointAdapter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricBuffer buffer = MetricBuffer.builder().attributes(this.commonAttributes).build();
        for (MetricData metric : metrics) {
            Attributes attributes = this.buildCommonAttributes(metric);
            Collection points = metric.getPoints();
            for (MetricData.Point point : points) {
                Collection<Metric> metricsFromPoint = this.metricPointAdapter.buildMetricsFromPoint(metric, attributes.copy(), point);
                metricsFromPoint.forEach(arg_0 -> ((MetricBuffer)buffer).addMetric(arg_0));
            }
        }
        this.timeTracker.tick();
        this.telemetryClient.sendBatch(buffer.createBatch());
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.telemetryClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }

    private Attributes buildCommonAttributes(MetricData metric) {
        Attributes attributes = new Attributes();
        AttributesSupport.addResourceAttributes(attributes, metric.getResource());
        AttributesSupport.populateLibraryInfo(attributes, metric.getInstrumentationLibraryInfo());
        attributes.put("description", metric.getDescription());
        attributes.put("unit", metric.getUnit());
        return attributes;
    }

    public static class Builder {
        private Attributes commonAttributes = new Attributes();
        private TelemetryClient telemetryClient;
        private String apiKey;
        private boolean enableAuditLogging = false;
        private URI uriOverride;

        public Builder telemetryClient(TelemetryClient telemetryClient) {
            this.telemetryClient = telemetryClient;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder enableAuditLogging() {
            this.enableAuditLogging = true;
            return this;
        }

        public Builder commonAttributes(Attributes commonAttributes) {
            this.commonAttributes = commonAttributes;
            return this;
        }

        public Builder uriOverride(URI uriOverride) {
            this.uriOverride = uriOverride;
            return this;
        }

        public NewRelicMetricExporter build() {
            TimeTracker timeTracker = new TimeTracker((Clock)SystemClock.getInstance());
            if (this.telemetryClient != null) {
                return new NewRelicMetricExporter(this.telemetryClient, this.commonAttributes, timeTracker, new MetricPointAdapter(timeTracker), AttributesSupport.SERVICE_INSTANCE_ID);
            }
            SenderConfiguration.SenderConfigurationBuilder builder = MetricBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new).configureWith(this.apiKey).secondaryUserAgent("NewRelic-OpenTelemetry-Exporter/" + VersionFinder.readVersion()).auditLoggingEnabled(this.enableAuditLogging);
            if (this.uriOverride != null) {
                try {
                    builder.endpoint(this.uriOverride.toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid URI for the metric API : " + this.uriOverride, e);
                }
            }
            this.telemetryClient = new TelemetryClient(MetricBatchSender.create((SenderConfiguration)builder.build()), null, null, null);
            return new NewRelicMetricExporter(this.telemetryClient, this.commonAttributes, timeTracker, new MetricPointAdapter(timeTracker), AttributesSupport.SERVICE_INSTANCE_ID);
        }
    }
}

