/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.opentelemetry.export.AttributeNames;
import com.newrelic.telemetry.opentelemetry.export.AttributesSupport;
import com.newrelic.telemetry.spans.Span;
import com.newrelic.telemetry.spans.SpanBatch;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class SpanBatchAdapter {
    private final Attributes commonAttributes;

    SpanBatchAdapter(Attributes commonAttributes, String serviceInstanceId) {
        this.commonAttributes = commonAttributes.copy().put("instrumentation.provider", "opentelemetry").put("collector.name", "newrelic-opentelemetry-exporter").put(AttributeNames.SERVICE_INSTANCE_ID, serviceInstanceId);
    }

    Collection<SpanBatch> adaptToSpanBatches(Collection<SpanData> openTracingSpans) {
        Map<Resource, List<SpanData>> spansGroupedByResource = openTracingSpans.stream().collect(Collectors.groupingBy(SpanData::getResource));
        return spansGroupedByResource.entrySet().stream().map(resourceSpans -> this.makeBatch((Resource)resourceSpans.getKey(), (List)resourceSpans.getValue(), this.commonAttributes)).collect(Collectors.toList());
    }

    private SpanBatch makeBatch(Resource resource, List<SpanData> spans, Attributes commonAttributes) {
        Attributes attributes = AttributesSupport.addResourceAttributes(commonAttributes.copy(), resource);
        List newRelicSpans = spans.stream().map(SpanBatchAdapter::makeNewRelicSpan).collect(Collectors.toList());
        return new SpanBatch(newRelicSpans, attributes);
    }

    private static Span makeNewRelicSpan(SpanData span) {
        Span.SpanBuilder spanBuilder = Span.builder((String)span.getSpanId()).name(span.getName().isEmpty() ? null : span.getName()).parentId(SpanBatchAdapter.makeParentSpanId(span.getParentSpanId())).traceId(span.getTraceId()).attributes(SpanBatchAdapter.generateSpanAttributes(span));
        spanBuilder.timestamp(SpanBatchAdapter.calculateTimestampMillis(span));
        spanBuilder.durationMs(SpanBatchAdapter.calculateDuration(span));
        return spanBuilder.build();
    }

    private static String makeParentSpanId(String parentSpanId) {
        if (SpanId.isValid((String)parentSpanId)) {
            return parentSpanId;
        }
        return null;
    }

    private static Attributes generateSpanAttributes(SpanData span) {
        Attributes attributes = new Attributes();
        attributes = SpanBatchAdapter.createIntrinsicAttributes(span, attributes);
        attributes = SpanBatchAdapter.addPossibleErrorAttribute(span, attributes);
        attributes = SpanBatchAdapter.addPossibleInstrumentationAttributes(span, attributes);
        return attributes;
    }

    private static Attributes addPossibleInstrumentationAttributes(SpanData span, Attributes attributes) {
        return AttributesSupport.populateLibraryInfo(attributes, span.getInstrumentationLibraryInfo());
    }

    private static Attributes createIntrinsicAttributes(SpanData span, Attributes attributes) {
        io.opentelemetry.api.common.Attributes originalAttributes = span.getAttributes();
        AttributesSupport.putInAttributes(attributes, originalAttributes);
        attributes.put("span.kind", span.getKind().name());
        return attributes;
    }

    private static Attributes addPossibleErrorAttribute(SpanData span, Attributes attributes) {
        SpanData.Status status = span.getStatus();
        if (!status.isOk()) {
            attributes.put("error.message", SpanBatchAdapter.getErrorMessage(status));
        }
        return attributes;
    }

    private static String getErrorMessage(SpanData.Status status) {
        String description = status.getDescription();
        return SpanBatchAdapter.isNullOrEmpty(description) ? status.getStatusCode().name() : description;
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static double calculateDuration(SpanData span) {
        long startTime = span.getStartEpochNanos();
        long endTime = span.getEndEpochNanos();
        long nanoDifference = endTime - startTime;
        return (double)nanoDifference / 1000000.0;
    }

    private static long calculateTimestampMillis(SpanData span) {
        return TimeUnit.NANOSECONDS.toMillis(span.getStartEpochNanos());
    }
}

