/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSAlgorithmProvider;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseJWSProvider
implements JWSAlgorithmProvider {
    private Set<JWSAlgorithm> algs;

    public BaseJWSProvider(Set<JWSAlgorithm> algs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWS algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
    }

    @Override
    public Set<JWSAlgorithm> supportedAlgorithms() {
        return this.algs;
    }
}

