/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import com.nimbusds.jose.crypto.ECDSAParameters;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;

abstract class ECDSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    protected ECDSAProvider() {
        super(SUPPORTED_ALGORITHMS);
    }

    protected static ECDSAParameters getECDSAParameters(JWSAlgorithm alg) throws JOSEException {
        ASN1ObjectIdentifier oid = null;
        SHA256Digest digest = null;
        if (alg.equals(JWSAlgorithm.ES256)) {
            oid = SECObjectIdentifiers.secp256r1;
            digest = new SHA256Digest();
        } else if (alg.equals(JWSAlgorithm.ES384)) {
            oid = SECObjectIdentifiers.secp384r1;
            digest = new SHA384Digest();
        } else if (alg.equals(JWSAlgorithm.ES512)) {
            oid = SECObjectIdentifiers.secp521r1;
            digest = new SHA512Digest();
        } else {
            throw new JOSEException("Unsupported ECDSA algorithm, must be ES256, ES384 or ES512");
        }
        X9ECParameters x9ECParams = SECNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
        return new ECDSAParameters(x9ECParams, (Digest)digest);
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.ES256);
        algs.add(JWSAlgorithm.ES384);
        algs.add(JWSAlgorithm.ES512);
        SUPPORTED_ALGORITHMS = algs;
    }
}

