/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.util.Base64URL;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWECryptoParts {
    private final Base64URL encryptedKey;
    private final Base64URL iv;
    private final Base64URL cipherText;
    private final Base64URL integrityValue;

    public JWECryptoParts(Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL integrityValue) {
        this.encryptedKey = encryptedKey;
        this.iv = iv;
        if (cipherText == null) {
            throw new IllegalArgumentException("The cipher text must not be null");
        }
        this.cipherText = cipherText;
        this.integrityValue = integrityValue;
    }

    public Base64URL getEncryptedKey() {
        return this.encryptedKey;
    }

    public Base64URL getInitializationVector() {
        return this.iv;
    }

    public Base64URL getCipherText() {
        return this.cipherText;
    }

    public Base64URL getIntegrityValue() {
        return this.integrityValue;
    }
}

