/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

class RSA_OAEP {
    public static byte[] encryptCMK(RSAPublicKey publicKey, SecretKey contentMasterKey) throws JOSEException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
            BigInteger mod = publicKey.getModulus();
            BigInteger exp = publicKey.getPublicExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(false, mod, exp);
            cipher.init(true, (CipherParameters)keyParams);
            int inputBlockSize = cipher.getInputBlockSize();
            int outputBlockSize = cipher.getOutputBlockSize();
            byte[] keyBytes = contentMasterKey.getEncoded();
            return cipher.processBlock(keyBytes, 0, keyBytes.length);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static SecretKey decryptCMK(RSAPrivateKey privateKey, byte[] encryptedCMK) throws JOSEException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
            BigInteger mod = privateKey.getModulus();
            BigInteger exp = privateKey.getPrivateExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(true, mod, exp);
            cipher.init(false, (CipherParameters)keyParams);
            byte[] secretKeyBytes = cipher.processBlock(encryptedCMK, 0, encryptedCMK.length);
            return new SecretKeySpec(secretKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    private RSA_OAEP() {
    }
}

