/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class EncryptionMethod
extends Algorithm {
    private final int cmkBitLength;
    public static final EncryptionMethod A128CBC_HS256 = new EncryptionMethod("A128CBC+HS256", Requirement.REQUIRED, 256);
    public static final EncryptionMethod A256CBC_HS512 = new EncryptionMethod("A256CBC+HS512", Requirement.REQUIRED, 512);
    public static final EncryptionMethod A128GCM = new EncryptionMethod("A128GCM", Requirement.RECOMMENDED, 128);
    public static final EncryptionMethod A256GCM = new EncryptionMethod("A256GCM", Requirement.RECOMMENDED, 256);

    public EncryptionMethod(String name, Requirement req, int cmkBitLength) {
        super(name, req);
        this.cmkBitLength = cmkBitLength;
    }

    public EncryptionMethod(String name, Requirement req) {
        this(name, req, 0);
    }

    public EncryptionMethod(String name) {
        this(name, null, 0);
    }

    public int cmkBitLength() {
        return this.cmkBitLength;
    }

    public static EncryptionMethod parse(String s) {
        if (s.equals(A128CBC_HS256.getName())) {
            return A128CBC_HS256;
        }
        if (s.equals(A256CBC_HS512.getName())) {
            return A256CBC_HS512;
        }
        if (s.equals(A128GCM.getName())) {
            return A128GCM;
        }
        if (s.equals(A256GCM.getName())) {
            return A256GCM;
        }
        return new EncryptionMethod(s);
    }
}

