/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.BaseJWEProvider;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

abstract class DirectCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    protected final SecretKey cmk;

    protected DirectCryptoProvider(byte[] key) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
        if (key.length != 16 && key.length != 32 && key.length != 64) {
            throw new JOSEException("The key length must be 128 bits (16 bytes), 256 bits (32 bytes) or 512 bites (64 bytes)");
        }
        this.cmk = new SecretKeySpec(key, "AES");
    }

    public byte[] getKey() {
        return this.cmk.getEncoded();
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.DIR);
        SUPPORTED_ALGORITHMS = algs;
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A256GCM);
        SUPPORTED_ENCRYPTION_METHODS = methods;
    }
}

