/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.ConcatKDF;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.DirectCryptoProvider;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.util.Base64URL;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    private final SecureRandom randomGen;

    public DirectEncrypter(byte[] key) throws JOSEException {
        super(key);
        try {
            this.randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public JWECryptoParts encrypt(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported algorithm, must be \"dir\"");
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.cmkBitLength() != this.getKey().length * 8) {
            throw new JOSEException("The key length must be " + enc.cmkBitLength() + " bits for " + enc + " encryption");
        }
        Base64URL encryptedKey = null;
        byte[] plainText = DeflateHelper.applyCompression(readOnlyJWEHeader, bytes);
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            byte[] epu = null;
            if (readOnlyJWEHeader.getEncryptionPartyUInfo() != null) {
                epu = readOnlyJWEHeader.getEncryptionPartyUInfo().decode();
            }
            byte[] epv = null;
            if (readOnlyJWEHeader.getEncryptionPartyVInfo() != null) {
                epv = readOnlyJWEHeader.getEncryptionPartyVInfo().decode();
            }
            SecretKey cek = ConcatKDF.generateCEK(this.cmk, enc, epu, epv);
            byte[] iv = AESCBC.generateIV(this.randomGen);
            byte[] cipherText = AESCBC.encrypt(cek, iv, plainText);
            SecretKey cik = ConcatKDF.generateCIK(this.cmk, enc, epu, epv);
            String macInput = readOnlyJWEHeader.toBase64URL().toString() + "." + "." + Base64URL.encode(iv).toString() + "." + Base64URL.encode(cipherText);
            byte[] mac = HMAC.compute(cik, macInput.getBytes());
            return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(cipherText), Base64URL.encode(mac));
        }
        if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            byte[] authData;
            byte[] iv = AESGCM.generateIV(this.randomGen);
            String authDataString = readOnlyJWEHeader.toBase64URL().toString() + "." + "." + Base64URL.encode(iv).toString();
            try {
                authData = authDataString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JOSEException(e.getMessage(), e);
            }
            AESGCM.Result result = AESGCM.encrypt(this.cmk, iv, plainText, authData);
            return new JWECryptoParts(encryptedKey, Base64URL.encode(iv), Base64URL.encode(result.getCipherText()), Base64URL.encode(result.getAuthenticationTag()));
        }
        throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
    }
}

