/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class RSAKey
extends JWK {
    private final Base64URL n;
    private final Base64URL e;
    private final Base64URL d;
    private final Base64URL p;
    private final Base64URL q;
    private final Base64URL dp;
    private final Base64URL dq;
    private final Base64URL qi;
    private final List<OtherPrimesInfo> oth;

    public RSAKey(Base64URL n, Base64URL e, Use use, Algorithm alg, String kid) {
        this(n, e, null, null, null, null, null, null, null, use, alg, kid);
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL d, Use use, Algorithm alg, String kid) {
        this(n, e, d, null, null, null, null, null, null, use, alg, kid);
        if (d == null) {
            throw new IllegalArgumentException("The private exponent must not be null");
        }
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL p, Base64URL q, Base64URL dp, Base64URL dq, Base64URL qi, List<OtherPrimesInfo> oth, Use use, Algorithm alg, String kid) {
        this(n, e, null, p, q, dp, dq, qi, oth, use, alg, kid);
        if (p == null) {
            throw new IllegalArgumentException("The first prime factor must not be null");
        }
        if (q == null) {
            throw new IllegalArgumentException("The second prime factor must not be null");
        }
        if (dp == null) {
            throw new IllegalArgumentException("The first factor CRT exponent must not be null");
        }
        if (dq == null) {
            throw new IllegalArgumentException("The second factor CRT exponent must not be null");
        }
        if (qi == null) {
            throw new IllegalArgumentException("The first CRT coefficient must not be null");
        }
    }

    public RSAKey(Base64URL n, Base64URL e, Base64URL d, Base64URL p, Base64URL q, Base64URL dp, Base64URL dq, Base64URL qi, List<OtherPrimesInfo> oth, Use use, Algorithm alg, String kid) {
        super(KeyType.RSA, use, alg, kid);
        if (n == null) {
            throw new IllegalArgumentException("The modulus value must not be null");
        }
        this.n = n;
        if (e == null) {
            throw new IllegalArgumentException("The public exponent value must not be null");
        }
        this.e = e;
        this.d = d;
        if (p != null && q != null && dp != null && dq != null && qi != null) {
            this.p = p;
            this.q = q;
            this.dp = dp;
            this.dq = dq;
            this.qi = qi;
            this.oth = oth != null ? Collections.unmodifiableList(oth) : Collections.emptyList();
        } else if (p == null && q == null && dp == null && dq == null && qi == null && oth == null) {
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        } else {
            if (p == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first prime factor must not be null");
            }
            if (q == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second prime factor must not be null");
            }
            if (dp == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first factor CRT exponent must not be null");
            }
            if (dq == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second factor CRT exponent must not be null");
            }
            if (qi == null) {
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first CRT coefficient must not be null");
            }
            throw new IllegalArgumentException("Incomplete second private (CRT) representation");
        }
    }

    public RSAKey(RSAPublicKey pub, Use use, Algorithm alg, String kid) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), use, alg, kid);
    }

    public RSAKey(RSAPublicKey pub, RSAPrivateKey priv, Use use, Algorithm alg, String kid) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), use, alg, kid);
    }

    public RSAKey(RSAPublicKey pub, RSAPrivateCrtKey priv, Use use, Algorithm alg, String kid) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), Base64URL.encode(priv.getPrimeP()), Base64URL.encode(priv.getPrimeQ()), Base64URL.encode(priv.getPrimeExponentP()), Base64URL.encode(priv.getPrimeExponentQ()), Base64URL.encode(priv.getCrtCoefficient()), null, use, alg, kid);
    }

    public RSAKey(RSAPublicKey pub, RSAMultiPrimePrivateCrtKey priv, Use use, Algorithm alg, String kid) {
        this(Base64URL.encode(pub.getModulus()), Base64URL.encode(pub.getPublicExponent()), Base64URL.encode(priv.getPrivateExponent()), Base64URL.encode(priv.getPrimeP()), Base64URL.encode(priv.getPrimeQ()), Base64URL.encode(priv.getPrimeExponentP()), Base64URL.encode(priv.getPrimeExponentQ()), Base64URL.encode(priv.getCrtCoefficient()), OtherPrimesInfo.toList(priv.getOtherPrimeInfo()), use, alg, kid);
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getPublicExponent() {
        return this.e;
    }

    public Base64URL getPrivateExponent() {
        return this.d;
    }

    public Base64URL getFirstPrimeFactor() {
        return this.p;
    }

    public Base64URL getSecondPrimeFactor() {
        return this.q;
    }

    public Base64URL getFirstFactorCRTExponent() {
        return this.dp;
    }

    public Base64URL getSecondFactorCRTExponent() {
        return this.dq;
    }

    public Base64URL getFirstCRTCoefficient() {
        return this.qi;
    }

    public List<OtherPrimesInfo> getOtherPrimes() {
        return this.oth;
    }

    public RSAPublicKey toRSAPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = this.n.decodeToBigInteger();
        BigInteger exponent = this.e.decodeToBigInteger();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPublicKey pub = (RSAPublicKey)factory.generatePublic(spec);
        return pub;
    }

    public RSAPrivateKey toRSAPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPrivateKeySpec spec;
        if (this.d == null) {
            return null;
        }
        BigInteger modulus = this.n.decodeToBigInteger();
        BigInteger privateExponent = this.d.decodeToBigInteger();
        if (this.p == null) {
            spec = new RSAPrivateKeySpec(modulus, privateExponent);
        } else {
            BigInteger publicExponent = this.e.decodeToBigInteger();
            BigInteger primeP = this.p.decodeToBigInteger();
            BigInteger primeQ = this.q.decodeToBigInteger();
            BigInteger primeExponentP = this.dp.decodeToBigInteger();
            BigInteger primeExponentQ = this.dq.decodeToBigInteger();
            BigInteger crtCoefficient = this.qi.decodeToBigInteger();
            if (this.oth != null && !this.oth.isEmpty()) {
                RSAOtherPrimeInfo[] otherInfo = new RSAOtherPrimeInfo[this.oth.size()];
                for (int i = 0; i < this.oth.size(); ++i) {
                    OtherPrimesInfo opi = this.oth.get(i);
                    BigInteger otherPrime = opi.getPrimeFactor().decodeToBigInteger();
                    BigInteger otherPrimeExponent = opi.getFactorCRTExponent().decodeToBigInteger();
                    BigInteger otherCrtCoefficient = opi.getFactorCRTCoefficient().decodeToBigInteger();
                    otherInfo[i] = new RSAOtherPrimeInfo(otherPrime, otherPrimeExponent, otherCrtCoefficient);
                }
                spec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient, otherInfo);
            } else {
                spec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
            }
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPrivateKey priv = (RSAPrivateKey)factory.generatePrivate(spec);
        return priv;
    }

    public KeyPair toKeyPair() throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new KeyPair(this.toRSAPublicKey(), this.toRSAPrivateKey());
    }

    @Override
    public boolean isPrivate() {
        return this.d != null || this.p != null;
    }

    @Override
    public RSAKey toPublicJWK() {
        return new RSAKey(this.getModulus(), this.getPublicExponent(), this.getKeyUse(), this.getAlgorithm(), this.getKeyID());
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"n", (Object)this.n.toString());
        o.put((Object)"e", (Object)this.e.toString());
        if (this.d != null) {
            o.put((Object)"d", (Object)this.d.toString());
        }
        if (this.p != null) {
            o.put((Object)"p", (Object)this.p.toString());
        }
        if (this.q != null) {
            o.put((Object)"q", (Object)this.q.toString());
        }
        if (this.dp != null) {
            o.put((Object)"dp", (Object)this.dp.toString());
        }
        if (this.dq != null) {
            o.put((Object)"dq", (Object)this.dq.toString());
        }
        if (this.qi != null) {
            o.put((Object)"qi", (Object)this.qi.toString());
        }
        if (this.oth != null && !this.oth.isEmpty()) {
            JSONArray a = new JSONArray();
            for (OtherPrimesInfo other : this.oth) {
                JSONObject oo = new JSONObject();
                oo.put((Object)"r", (Object)other.r.toString());
                oo.put((Object)"d", (Object)other.d.toString());
                oo.put((Object)"t", (Object)other.t.toString());
                a.add((Object)oo);
            }
            o.put((Object)"oth", (Object)a);
        }
        return o;
    }

    public static RSAKey parse(String s) throws ParseException {
        return RSAKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static RSAKey parse(JSONObject jsonObject) throws ParseException {
        Base64URL n = new Base64URL(JSONObjectUtils.getString(jsonObject, "n"));
        Base64URL e = new Base64URL(JSONObjectUtils.getString(jsonObject, "e"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.RSA) {
            throw new ParseException("The key type \"kty\" must be RSA", 0);
        }
        Base64URL d = null;
        if (jsonObject.get((Object)"d") != null) {
            d = new Base64URL(JSONObjectUtils.getString(jsonObject, "d"));
        }
        Base64URL p = null;
        if (jsonObject.get((Object)"p") != null) {
            p = new Base64URL(JSONObjectUtils.getString(jsonObject, "p"));
        }
        Base64URL q = null;
        if (jsonObject.get((Object)"q") != null) {
            q = new Base64URL(JSONObjectUtils.getString(jsonObject, "q"));
        }
        Base64URL dp = null;
        if (jsonObject.get((Object)"dp") != null) {
            dp = new Base64URL(JSONObjectUtils.getString(jsonObject, "dp"));
        }
        Base64URL dq = null;
        if (jsonObject.get((Object)"dq") != null) {
            dq = new Base64URL(JSONObjectUtils.getString(jsonObject, "dq"));
        }
        Base64URL qi = null;
        if (jsonObject.get((Object)"qi") != null) {
            qi = new Base64URL(JSONObjectUtils.getString(jsonObject, "qi"));
        }
        ArrayList<OtherPrimesInfo> oth = null;
        if (jsonObject.get((Object)"oth") != null) {
            JSONArray arr = JSONObjectUtils.getJSONArray(jsonObject, "oth");
            oth = new ArrayList<OtherPrimesInfo>(arr.size());
            for (Object o : arr) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject otherJson = (JSONObject)o;
                Base64URL r = new Base64URL(JSONObjectUtils.getString(otherJson, "r"));
                Base64URL odq = new Base64URL(JSONObjectUtils.getString(otherJson, "dq"));
                Base64URL t = new Base64URL(JSONObjectUtils.getString(otherJson, "t"));
                OtherPrimesInfo prime = new OtherPrimesInfo(r, odq, t);
                oth.add(prime);
            }
        }
        Use use = JWK.parseKeyUse(jsonObject);
        Algorithm alg = JWK.parseAlgorithm(jsonObject);
        String kid = JWK.parseKeyID(jsonObject);
        try {
            return new RSAKey(n, e, d, p, q, dp, dq, qi, oth, use, alg, kid);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static class OtherPrimesInfo {
        private final Base64URL r;
        private final Base64URL d;
        private final Base64URL t;

        public OtherPrimesInfo(Base64URL r, Base64URL d, Base64URL t) {
            if (r == null) {
                throw new IllegalArgumentException("The prime factor must not be null");
            }
            this.r = r;
            if (d == null) {
                throw new IllegalArgumentException("The factor CRT exponent must not be null");
            }
            this.d = d;
            if (t == null) {
                throw new IllegalArgumentException("The factor CRT coefficient must not be null");
            }
            this.t = t;
        }

        public OtherPrimesInfo(RSAOtherPrimeInfo oth) {
            this.r = Base64URL.encode(oth.getPrime());
            this.d = Base64URL.encode(oth.getExponent());
            this.t = Base64URL.encode(oth.getCrtCoefficient());
        }

        public Base64URL getPrimeFactor() {
            return this.r;
        }

        public Base64URL getFactorCRTExponent() {
            return this.d;
        }

        public Base64URL getFactorCRTCoefficient() {
            return this.t;
        }

        public static List<OtherPrimesInfo> toList(RSAOtherPrimeInfo[] othArray) {
            ArrayList<OtherPrimesInfo> list = new ArrayList<OtherPrimesInfo>();
            if (othArray == null) {
                return list;
            }
            for (RSAOtherPrimeInfo oth : othArray) {
                list.add(new OtherPrimesInfo(oth));
            }
            return list;
        }
    }
}

