/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.ReadOnlyPlainHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainHeader
extends Header
implements ReadOnlyPlainHeader {
    private static final Set<String> RESERVED_PARAMETER_NAMES;

    public PlainHeader() {
        super(Algorithm.NONE);
    }

    public static Set<String> getReservedParameterNames() {
        return RESERVED_PARAMETER_NAMES;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.alg;
    }

    @Override
    public void setCustomParameter(String name, Object value) {
        if (PlainHeader.getReservedParameterNames().contains(name)) {
            throw new IllegalArgumentException("The parameter name \"" + name + "\" matches a reserved name");
        }
        super.setCustomParameter(name, value);
    }

    @Override
    public Set<String> getIncludedParameters() {
        HashSet<String> includedParameters = new HashSet<String>(this.getCustomParameters().keySet());
        includedParameters.add("alg");
        if (this.getType() != null) {
            includedParameters.add("typ");
        }
        if (this.getContentType() != null) {
            includedParameters.add("cty");
        }
        if (this.getCriticalHeaders() != null && !this.getCriticalHeaders().isEmpty()) {
            includedParameters.add("crit");
        }
        return includedParameters;
    }

    public static PlainHeader parse(JSONObject json) throws ParseException {
        Algorithm alg = Header.parseAlgorithm(json);
        if (alg != Algorithm.NONE) {
            throw new ParseException("The algorithm \"alg\" header parameter must be \"none\"", 0);
        }
        PlainHeader h = new PlainHeader();
        for (String name : json.keySet()) {
            if (name.equals("alg")) continue;
            if (name.equals("typ")) {
                h.setType(new JOSEObjectType(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("cty")) {
                h.setContentType(JSONObjectUtils.getString(json, name));
                continue;
            }
            if (name.equals("crit")) {
                h.setCriticalHeaders(new HashSet<String>(JSONObjectUtils.getStringList(json, name)));
                continue;
            }
            h.setCustomParameter(name, json.get((Object)name));
        }
        return h;
    }

    public static PlainHeader parse(String s) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parseJSONObject(s);
        return PlainHeader.parse(jsonObject);
    }

    public static PlainHeader parse(Base64URL base64URL) throws ParseException {
        if (base64URL == null) {
            throw new ParseException("The Base64URL must not be null", 0);
        }
        PlainHeader header = PlainHeader.parse(base64URL.decodeToString());
        header.setParsedBase64URL(base64URL);
        return header;
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("alg");
        p.add("typ");
        p.add("cty");
        p.add("crit");
        RESERVED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

