/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.DefaultHeaderFilter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEHeaderFilter;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultJWEHeaderFilter
extends DefaultHeaderFilter
implements JWEHeaderFilter {
    private final Set<JWEAlgorithm> algs;
    private Set<JWEAlgorithm> acceptedAlgs;
    private final Set<EncryptionMethod> encs;
    private Set<EncryptionMethod> acceptedEncs;

    private static void validateAcceptedParameters(Set<String> acceptedParams) {
        if (!acceptedParams.contains("alg") || !acceptedParams.contains("enc")) {
            throw new IllegalArgumentException("The accepted JWE header parameters set must include at least the \"alg\" and \"enc\" parameters");
        }
    }

    public DefaultJWEHeaderFilter(Set<JWEAlgorithm> algs, Set<EncryptionMethod> encs) {
        this(algs, encs, JWEHeader.getRegisteredParameterNames());
    }

    public DefaultJWEHeaderFilter(Set<JWEAlgorithm> algs, Set<EncryptionMethod> encs, Set<String> acceptedParams) {
        super(acceptedParams);
        DefaultJWEHeaderFilter.validateAcceptedParameters(acceptedParams);
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        this.acceptedAlgs = this.algs;
        if (encs == null) {
            throw new IllegalArgumentException("The supported encryption methods set must not be null");
        }
        this.encs = Collections.unmodifiableSet(encs);
        this.acceptedEncs = this.encs;
    }

    public Set<JWEAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<JWEAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWEAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWE algorithm set must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("One or more of the JWE algorithms is not in the supported set");
        }
        this.acceptedAlgs = Collections.unmodifiableSet(acceptedAlgs);
    }

    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }

    @Override
    public Set<EncryptionMethod> getAcceptedEncryptionMethods() {
        return this.acceptedEncs;
    }

    @Override
    public void setAcceptedEncryptionMethods(Set<EncryptionMethod> acceptedEncs) {
        if (acceptedEncs == null) {
            throw new IllegalArgumentException("The accepted encryption methods set must not be null");
        }
        if (!this.encs.containsAll(acceptedEncs)) {
            throw new IllegalArgumentException("One or more of the encryption methods is not in the supported set");
        }
        this.acceptedEncs = Collections.unmodifiableSet(acceptedEncs);
    }

    @Override
    public void setAcceptedParameters(Set<String> acceptedParams) {
        DefaultJWEHeaderFilter.validateAcceptedParameters(acceptedParams);
        super.setAcceptedParameters(acceptedParams);
    }
}

