/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class HMAC {
    HMAC() {
    }

    public static byte[] compute(String alg, byte[] secret, byte[] message) throws JOSEException {
        return HMAC.compute(new SecretKeySpec(secret, alg), message);
    }

    public static byte[] compute(SecretKey secretKey, byte[] message) throws JOSEException {
        Mac mac;
        try {
            mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Unsupported HMAC algorithm: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid HMAC key: " + e.getMessage(), e);
        }
        mac.update(message);
        return mac.doFinal();
    }
}

