/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class OctetSequenceKey
extends JWK {
    private final Base64URL k;

    public OctetSequenceKey(Base64URL k, Use use, Algorithm alg, String kid, URL x5u, Base64URL x5t, List<Base64> x5c) {
        super(KeyType.OCT, use, alg, kid, x5u, x5t, x5c);
        if (k == null) {
            throw new IllegalArgumentException("The key value must not be null");
        }
        this.k = k;
    }

    public Base64URL getKeyValue() {
        return this.k;
    }

    public byte[] toByteArray() {
        return this.getKeyValue().decode();
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    public OctetSequenceKey toPublicJWK() {
        return null;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"k", (Object)this.k.toString());
        return o;
    }

    public static OctetSequenceKey parse(String s) throws ParseException {
        return OctetSequenceKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static OctetSequenceKey parse(JSONObject jsonObject) throws ParseException {
        Base64URL k = new Base64URL(JSONObjectUtils.getString(jsonObject, "k"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.OCT) {
            throw new ParseException("The key type \"kty\" must be oct", 0);
        }
        Use use = null;
        if (jsonObject.containsKey((Object)"use")) {
            use = Use.parse(JSONObjectUtils.getString(jsonObject, "use"));
        }
        Algorithm alg = null;
        if (jsonObject.containsKey((Object)"alg")) {
            alg = new Algorithm(JSONObjectUtils.getString(jsonObject, "alg"));
        }
        String kid = null;
        if (jsonObject.containsKey((Object)"kid")) {
            kid = JSONObjectUtils.getString(jsonObject, "kid");
        }
        URL x5u = null;
        if (jsonObject.containsKey((Object)"x5u")) {
            x5u = JSONObjectUtils.getURL(jsonObject, "x5u");
        }
        Base64URL x5t = null;
        if (jsonObject.containsKey((Object)"x5t")) {
            x5t = new Base64URL(JSONObjectUtils.getString(jsonObject, "x5t"));
        }
        List<Base64> x5c = null;
        if (jsonObject.containsKey((Object)"x5c")) {
            x5c = X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(jsonObject, "x5c"));
        }
        return new OctetSequenceKey(k, use, alg, kid, x5u, x5t, x5c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Base64URL k;
        private Use use;
        private Algorithm alg;
        private String kid;
        private URL x5u;
        private Base64URL x5t;
        private List<Base64> x5c;

        public Builder(Base64URL k) {
            if (k == null) {
                throw new IllegalArgumentException("The key value must not be null");
            }
            this.k = k;
        }

        public Builder keyUse(Use use) {
            this.use = use;
            return this;
        }

        public Builder algorithm(Algorithm alg) {
            this.alg = alg;
            return this;
        }

        public Builder keyID(String kid) {
            this.kid = kid;
            return this;
        }

        public Builder x509CertURL(URL x5u) {
            this.x5u = x5u;
            return this;
        }

        public Builder x509CertThumbprint(Base64URL x5t) {
            this.x5t = x5t;
            return this;
        }

        public Builder x509CertChain(List<Base64> x5c) {
            this.x5c = x5c;
            return this;
        }

        public OctetSequenceKey build() {
            return new OctetSequenceKey(this.k, this.use, this.alg, this.kid, this.x5u, this.x5t, this.x5c);
        }
    }
}

