/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.CommonSEHeader;
import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWEHeader
extends CommonSEHeader
implements ReadOnlyJWEHeader {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private EncryptionMethod enc;
    private ECKey epk;
    private CompressionAlgorithm zip;
    private Base64URL apu;
    private Base64URL apv;
    private Base64URL p2s;
    private int p2c;

    public JWEHeader(JWEAlgorithm alg, EncryptionMethod enc) {
        super(alg);
        if (alg.getName().equals(Algorithm.NONE.getName())) {
            throw new IllegalArgumentException("The JWE algorithm cannot be \"none\"");
        }
        if (enc == null) {
            throw new IllegalArgumentException("The encryption method \"enc\" parameter must not be null");
        }
        this.enc = enc;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public JWEAlgorithm getAlgorithm() {
        return (JWEAlgorithm)this.alg;
    }

    @Override
    public EncryptionMethod getEncryptionMethod() {
        return this.enc;
    }

    @Override
    public ECKey getEphemeralPublicKey() {
        return this.epk;
    }

    public void setEphemeralPublicKey(ECKey epk) {
        this.epk = epk;
    }

    @Override
    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.zip;
    }

    public void setCompressionAlgorithm(CompressionAlgorithm zip) {
        this.zip = zip;
    }

    @Override
    public Base64URL getAgreementPartyUInfo() {
        return this.apu;
    }

    public void setAgreementPartyUInfo(Base64URL apu) {
        this.apu = apu;
    }

    @Override
    public Base64URL getAgreementPartyVInfo() {
        return this.apv;
    }

    public void setAgreementPartyVInfo(Base64URL apv) {
        this.apv = apv;
    }

    @Override
    public Base64URL getPBES2Salt() {
        return this.p2s;
    }

    public void setPBES2Salt(Base64URL p2s) {
        this.p2s = p2s;
    }

    @Override
    public int getPBES2Count() {
        return this.p2c;
    }

    public void setPBES2Count(int p2c) {
        if (p2c < 0) {
            throw new IllegalArgumentException("The PBES2 count parameter must not be negative");
        }
        this.p2c = p2c;
    }

    @Override
    public void setCustomParameter(String name, Object value) {
        if (JWEHeader.getRegisteredParameterNames().contains(name)) {
            throw new IllegalArgumentException("The parameter name \"" + name + "\" matches a registered name");
        }
        super.setCustomParameter(name, value);
    }

    @Override
    public Set<String> getIncludedParameters() {
        HashSet<String> includedParameters = new HashSet<String>(this.getCustomParameters().keySet());
        includedParameters.add("alg");
        includedParameters.add("enc");
        if (this.getEphemeralPublicKey() != null) {
            includedParameters.add("epk");
        }
        if (this.getCompressionAlgorithm() != null) {
            includedParameters.add("zip");
        }
        if (this.getType() != null) {
            includedParameters.add("typ");
        }
        if (this.getContentType() != null) {
            includedParameters.add("cty");
        }
        if (this.getCriticalHeaders() != null && !this.getCriticalHeaders().isEmpty()) {
            includedParameters.add("crit");
        }
        if (this.getJWKURL() != null) {
            includedParameters.add("jku");
        }
        if (this.getJWK() != null) {
            includedParameters.add("jwk");
        }
        if (this.getX509CertURL() != null) {
            includedParameters.add("x5u");
        }
        if (this.getX509CertThumbprint() != null) {
            includedParameters.add("x5t");
        }
        if (this.getX509CertChain() != null) {
            includedParameters.add("x5c");
        }
        if (this.getKeyID() != null) {
            includedParameters.add("kid");
        }
        if (this.getAgreementPartyUInfo() != null) {
            includedParameters.add("apu");
        }
        if (this.getAgreementPartyVInfo() != null) {
            includedParameters.add("apv");
        }
        if (this.getPBES2Salt() != null) {
            includedParameters.add("p2s");
        }
        if (this.getPBES2Count() > 0) {
            includedParameters.add("p2c");
        }
        return includedParameters;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.enc != null) {
            o.put((Object)"enc", (Object)this.enc.toString());
        }
        if (this.epk != null) {
            o.put((Object)"epk", (Object)this.epk.toJSONObject());
        }
        if (this.zip != null) {
            o.put((Object)"zip", (Object)this.zip.toString());
        }
        if (this.apu != null) {
            o.put((Object)"apu", (Object)this.apu.toString());
        }
        if (this.apv != null) {
            o.put((Object)"apv", (Object)this.apv.toString());
        }
        if (this.p2s != null) {
            o.put((Object)"p2s", (Object)this.p2s.toString());
        }
        if (this.p2c > 0) {
            o.put((Object)"p2c", (Object)this.p2c);
        }
        return o;
    }

    private static EncryptionMethod parseEncryptionMethod(JSONObject json) throws ParseException {
        return EncryptionMethod.parse(JSONObjectUtils.getString(json, "enc"));
    }

    public static JWEHeader parse(JSONObject json) throws ParseException {
        Algorithm alg = Header.parseAlgorithm(json);
        if (!(alg instanceof JWEAlgorithm)) {
            throw new ParseException("The algorithm \"alg\" header parameter must be for encryption", 0);
        }
        EncryptionMethod enc = JWEHeader.parseEncryptionMethod(json);
        JWEHeader h = new JWEHeader((JWEAlgorithm)alg, enc);
        for (String name : json.keySet()) {
            if (name.equals("alg") || name.equals("enc")) continue;
            if (name.equals("epk")) {
                h.setEphemeralPublicKey(ECKey.parse(JSONObjectUtils.getJSONObject(json, name)));
                continue;
            }
            if (name.equals("zip")) {
                h.setCompressionAlgorithm(new CompressionAlgorithm(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("typ")) {
                h.setType(new JOSEObjectType(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("cty")) {
                h.setContentType(JSONObjectUtils.getString(json, name));
                continue;
            }
            if (name.equals("crit")) {
                h.setCriticalHeaders(new HashSet<String>(JSONObjectUtils.getStringList(json, name)));
                continue;
            }
            if (name.equals("jku")) {
                h.setJWKURL(JSONObjectUtils.getURL(json, name));
                continue;
            }
            if (name.equals("jwk")) {
                h.setJWK(JWK.parse(JSONObjectUtils.getJSONObject(json, name)));
                continue;
            }
            if (name.equals("x5u")) {
                h.setX509CertURL(JSONObjectUtils.getURL(json, name));
                continue;
            }
            if (name.equals("x5t")) {
                h.setX509CertThumbprint(new Base64URL(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("x5c")) {
                h.setX509CertChain((List)X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(json, name)));
                continue;
            }
            if (name.equals("kid")) {
                h.setKeyID(JSONObjectUtils.getString(json, name));
                continue;
            }
            if (name.equals("apu")) {
                h.setAgreementPartyUInfo(new Base64URL(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("apv")) {
                h.setAgreementPartyVInfo(new Base64URL(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("p2s")) {
                h.setPBES2Salt(new Base64URL(JSONObjectUtils.getString(json, name)));
                continue;
            }
            if (name.equals("p2c")) {
                h.setPBES2Count(JSONObjectUtils.getInt(json, name));
                continue;
            }
            h.setCustomParameter(name, json.get((Object)name));
        }
        return h;
    }

    public static JWEHeader parse(String s) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parseJSONObject(s);
        return JWEHeader.parse(jsonObject);
    }

    public static JWEHeader parse(Base64URL base64URL) throws ParseException {
        JWEHeader header = JWEHeader.parse(base64URL.decodeToString());
        header.setParsedBase64URL(base64URL);
        return header;
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("alg");
        p.add("enc");
        p.add("epk");
        p.add("zip");
        p.add("jku");
        p.add("jwk");
        p.add("x5u");
        p.add("x5t");
        p.add("x5c");
        p.add("kid");
        p.add("typ");
        p.add("cty");
        p.add("crit");
        p.add("apu");
        p.add("apv");
        p.add("p2s");
        p.add("p2c");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

