/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.DefaultJWSHeaderFilter;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.RSASSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements JWSVerifier {
    private final DefaultJWSHeaderFilter headerFilter;
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        this.headerFilter = new DefaultJWSHeaderFilter(this.supportedAlgorithms());
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public JWSHeaderFilter getJWSHeaderFilter() {
        return this.headerFilter;
    }

    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        Signature verifier = RSASSAVerifier.getRSASignerAndVerifier(header.getAlgorithm(), this.provider);
        try {
            verifier.initVerify(this.publicKey);
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid public RSA key: " + e.getMessage(), e);
        }
        try {
            verifier.update(signedContent);
            return verifier.verify(signature.decode());
        }
        catch (SignatureException e) {
            return false;
        }
    }
}

