/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWK;
import com.nimbusds.jose.KeyType;
import com.nimbusds.jose.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class ECKey
extends JWK {
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;

    public ECKey(Curve crv, Base64URL x, Base64URL y, Use use, Algorithm alg, String kid) {
        super(KeyType.EC, use, alg, kid);
        if (crv == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = crv;
        if (x == null) {
            throw new IllegalArgumentException("The x coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The y coordinate must not be null");
        }
        this.y = y;
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"crv", (Object)this.crv.toString());
        o.put((Object)"x", (Object)this.x.toString());
        o.put((Object)"y", (Object)this.y.toString());
        return o;
    }

    public static ECKey parse(JSONObject jsonObject) throws ParseException {
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        Curve crv = Curve.parse(JSONObjectUtils.getString(jsonObject, "crv"));
        Base64URL x = new Base64URL(JSONObjectUtils.getString(jsonObject, "x"));
        Base64URL y = new Base64URL(JSONObjectUtils.getString(jsonObject, "y"));
        Use use = JWK.parseKeyUse(jsonObject);
        Algorithm alg = JWK.parseAlgorithm(jsonObject);
        String id = JWK.parseKeyID(jsonObject);
        if (kty != KeyType.EC) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        return new ECKey(crv, x, y, use, alg, id);
    }

    @Immutable
    public static class Curve {
        public static final Curve P_256 = new Curve("P-256");
        public static final Curve P_384 = new Curve("P-384");
        public static final Curve P_521 = new Curve("P-521");
        private final String name;

        public Curve(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The cryptographic curve name must not be null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            return object instanceof Curve && this.toString().equals(object.toString());
        }

        public static Curve parse(String s) throws ParseException {
            if (s == null) {
                throw new IllegalArgumentException("The cryptographic curve sting must not be null");
            }
            if (s == P_256.getName()) {
                return P_256;
            }
            if (s == P_384.getName()) {
                return P_384;
            }
            if (s == P_521.getName()) {
                return P_521;
            }
            return new Curve(s);
        }
    }
}

