/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESCryptoProvider;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.AESGCMKW;
import com.nimbusds.jose.crypto.AESKW;
import com.nimbusds.jose.crypto.AuthenticatedCipherText;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.StringUtils;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESEncrypter
extends AESCryptoProvider
implements JWEEncrypter {
    private final SecretKey kek;

    public AESEncrypter(SecretKey kek) {
        if (kek == null) {
            throw new IllegalArgumentException("The Key Encrypting Key must not be null");
        }
        this.kek = kek;
    }

    public AESEncrypter(byte[] keyBytes) {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public SecretKey getKey() {
        return this.kek;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] bytes) throws JOSEException {
        AuthenticatedCipherText authCipherText;
        byte[] iv;
        JWEHeader modifiableHeader;
        Base64URL encryptedKey;
        AlgFamily algFamily;
        JWEAlgorithm alg = header.getAlgorithm();
        EncryptionMethod enc = header.getEncryptionMethod();
        SecureRandom randomGen = this.getSecureRandom();
        SecretKey cek = AES.generateKey(enc.cekBitLength(), randomGen);
        if (alg.equals(JWEAlgorithm.A128KW)) {
            if (this.kek.getEncoded().length != 16) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 128 bits for A128KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A192KW)) {
            if (this.kek.getEncoded().length != 24) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 192 bits for A192KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A256KW)) {
            if (this.kek.getEncoded().length != 32) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 256 bits for A256KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (alg.equals(JWEAlgorithm.A128GCMKW)) {
            if (this.kek.getEncoded().length != 16) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 128 bits for A128GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (alg.equals(JWEAlgorithm.A192GCMKW)) {
            if (this.kek.getEncoded().length != 24) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 192 bits for A192GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (alg.equals(JWEAlgorithm.A256GCMKW)) {
            if (this.kek.getEncoded().length != 32) {
                throw new JOSEException("The Key Encryption Key (KEK) length must be 256 bits for A256GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be A128KW, A192KW, A256KW, A128GCMKW, A192GCMKW orA256GCMKW");
        }
        if (AlgFamily.AESKW.equals((Object)algFamily)) {
            encryptedKey = Base64URL.encode(AESKW.encryptCEK(cek, this.kek));
            modifiableHeader = header;
        } else if (AlgFamily.AESGCMKW.equals((Object)algFamily)) {
            byte[] keyIV = AESGCM.generateIV(randomGen);
            AuthenticatedCipherText authCiphCEK = AESGCMKW.encryptCEK(cek, keyIV, this.kek, this.keyEncryptionProvider);
            encryptedKey = Base64URL.encode(authCiphCEK.getCipherText());
            modifiableHeader = new JWEHeader.Builder(header).iv(Base64URL.encode(keyIV)).authTag(Base64URL.encode(authCiphCEK.getAuthenticationTag())).build();
        } else {
            throw new JOSEException("Unsupported JWE algorithm, must be A128KW, A192KW, A256KW, A128GCMKW, A192GCMKW orA256GCMKW");
        }
        byte[] plainText = DeflateHelper.applyCompression(modifiableHeader, bytes);
        byte[] aad = StringUtils.toByteArray(modifiableHeader.toBase64URL().toString());
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A192CBC_HS384) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptAuthenticated(cek, iv, plainText, aad, this.contentEncryptionProvider, this.macProvider);
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A192GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            iv = AESGCM.generateIV(randomGen);
            authCipherText = AESGCM.encrypt(cek, iv, plainText, aad, this.contentEncryptionProvider);
        } else if (enc.equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || enc.equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            iv = AESCBC.generateIV(randomGen);
            authCipherText = AESCBC.encryptWithConcatKDF(modifiableHeader, cek, encryptedKey, iv, plainText, this.contentEncryptionProvider, this.macProvider);
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A192CBC_HS384, A256CBC_HS512, A128GCM, A192GCM or A256GCM");
        }
        return new JWECryptoParts(modifiableHeader, encryptedKey, Base64URL.encode(iv), Base64URL.encode(authCipherText.getCipherText()), Base64URL.encode(authCipherText.getAuthenticationTag()));
    }

    private static enum AlgFamily {
        AESKW,
        AESGCMKW;

    }
}

