/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.AbstractRestrictedResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.RestrictedResourceRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout) {
        this(connectTimeout, readTimeout, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit) {
        super(connectTimeout, readTimeout, sizeLimit);
    }

    @Override
    public Resource retrieveResource(URL url) throws IOException {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)url.openConnection();
        }
        catch (ClassCastException e) {
            throw new IOException("Couldn't open HTTP(S) connection: " + e.getMessage(), e);
        }
        con.setConnectTimeout(this.getConnectTimeout());
        con.setReadTimeout(this.getReadTimeout());
        InputStream inputStream = con.getInputStream();
        if (this.getSizeLimit() > 0) {
            inputStream = new BoundedInputStream(inputStream, (long)this.getSizeLimit());
        }
        String content = IOUtils.toString((InputStream)inputStream);
        int statusCode = con.getResponseCode();
        String statusMessage = con.getResponseMessage();
        if (statusCode > 299 || statusCode < 200) {
            throw new IOException("HTTP " + statusCode + ": " + statusMessage);
        }
        return new Resource(content, con.getContentType());
    }
}

