/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ClockSkewAware;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Date;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier<C extends SecurityContext>
implements JWTClaimsSetVerifier<C>,
JWTClaimsVerifier,
ClockSkewAware {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private int maxClockSkew = 60;
    private boolean iatRequired = false;
    private boolean expRequired = false;
    private boolean nbfRequired = false;
    private String acceptedIssuer;
    private String acceptedAudience;

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int maxClockSkewSeconds) {
        this.maxClockSkew = maxClockSkewSeconds;
    }

    public boolean requiresIssuedAtTime() {
        return this.iatRequired;
    }

    public void requiresIssuedAtTime(boolean iatRequired) {
        this.iatRequired = iatRequired;
    }

    public boolean requiresExpirationTime() {
        return this.expRequired;
    }

    public void requiresExpirationTime(boolean expRequired) {
        this.expRequired = expRequired;
    }

    public boolean requiresNotBeforeTime() {
        return this.nbfRequired;
    }

    public void requiresNotBeforeTime(boolean nbfRequired) {
        this.nbfRequired = nbfRequired;
    }

    public String getAcceptedIssuer() {
        return this.acceptedIssuer;
    }

    public void setAcceptedIssuer(String iss) {
        this.acceptedIssuer = iss;
    }

    public String getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public void setAcceptedAudience(String aud) {
        this.acceptedAudience = aud;
    }

    @Override
    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        this.verify(claimsSet, null);
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, C context) throws BadJWTException {
        if (this.iatRequired && claimsSet.getIssueTime() == null) {
            throw new BadJWTException("JWT issued-at time missing");
        }
        Date now = new Date();
        Date exp = claimsSet.getExpirationTime();
        if (this.expRequired && exp == null) {
            throw new BadJWTException("JWT expiration time missing");
        }
        if (exp != null && !DateUtils.isAfter(exp, now, this.maxClockSkew)) {
            throw new BadJWTException("Expired JWT");
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (this.nbfRequired && nbf == null) {
            throw new BadJWTException("JWT not-before time missing");
        }
        if (nbf != null && !DateUtils.isBefore(nbf, now, this.maxClockSkew)) {
            throw new BadJWTException("JWT before use time");
        }
        if (this.acceptedIssuer != null) {
            String iss = claimsSet.getIssuer();
            if (iss == null) {
                throw new BadJWTException("JWT issuer missing");
            }
            if (!this.acceptedIssuer.equals(iss)) {
                throw new BadJWTException("JWT issuer not accepted: " + iss);
            }
        }
        if (this.acceptedAudience != null) {
            List<String> audList = claimsSet.getAudience();
            if (audList == null || audList.isEmpty()) {
                throw new BadJWTException("JWT audience missing");
            }
            if (!audList.contains(this.acceptedAudience)) {
                throw new BadJWTException("JWT audience not accepted: " + audList);
            }
        }
    }
}

